/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.graphlib.api.wire;

import com.kneelawk.graphlib.api.graph.GraphView;
import com.kneelawk.graphlib.api.graph.NodeHolder;
import com.kneelawk.graphlib.api.graph.user.BlockNode;
import com.kneelawk.graphlib.api.graph.user.SidedBlockNode;
import com.kneelawk.graphlib.api.util.DirectionUtils;
import com.kneelawk.graphlib.api.util.EmptyLinkKey;
import com.kneelawk.graphlib.api.util.HalfLink;
import com.kneelawk.graphlib.api.wire.CenterWireBlockNode;
import com.kneelawk.graphlib.api.wire.CenterWireConnectionFilter;
import com.kneelawk.graphlib.api.wire.FullWireBlockNode;
import com.kneelawk.graphlib.api.wire.FullWireConnectionFilter;
import com.kneelawk.graphlib.api.wire.LinkKeyFactory;
import com.kneelawk.graphlib.api.wire.SidedFaceBlockNode;
import com.kneelawk.graphlib.api.wire.SidedFaceConnectionFilter;
import com.kneelawk.graphlib.api.wire.SidedWireBlockNode;
import com.kneelawk.graphlib.api.wire.SidedWireConnectionFilter;
import com.kneelawk.graphlib.api.wire.WireConnectionType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WireConnectionDiscoverers {
    private WireConnectionDiscoverers() {
    }

    @NotNull
    public static Collection<HalfLink> sidedWireFindConnections(@NotNull SidedWireBlockNode self, @NotNull NodeHolder<BlockNode> holder) {
        return WireConnectionDiscoverers.sidedWireFindConnections(self, holder, null, EmptyLinkKey.FACTORY);
    }

    @NotNull
    public static Collection<HalfLink> sidedWireFindConnections(@NotNull SidedWireBlockNode self, @NotNull NodeHolder<BlockNode> holder, @Nullable SidedWireConnectionFilter filter) {
        return WireConnectionDiscoverers.sidedWireFindConnections(self, holder, filter, EmptyLinkKey.FACTORY);
    }

    @NotNull
    public static Collection<HalfLink> sidedWireFindConnections(@NotNull SidedWireBlockNode self, @NotNull NodeHolder<BlockNode> holder, @Nullable SidedWireConnectionFilter filter, @NotNull LinkKeyFactory keyFactory) {
        GraphView graphView = holder.getGraphWorld();
        class_2338 pos = holder.getBlockPos();
        class_2350 side = self.getSide();
        ArrayList<HalfLink> collector = new ArrayList<HalfLink>();
        WireConnectionDiscoverers.addFilteredNodes(self, holder, filter, keyFactory, graphView, pos, collector);
        for (class_2350 external : DirectionUtils.perpendiculars(side)) {
            WireConnectionDiscoverers.addFilteredNodes(self, holder, filter, keyFactory, graphView, pos.method_10093(external), collector);
        }
        class_2338 under = pos.method_10093(side);
        for (class_2350 corner : DirectionUtils.perpendiculars(side)) {
            WireConnectionDiscoverers.addFilteredNodes(self, holder, filter, keyFactory, graphView, under.method_10093(corner), collector);
        }
        WireConnectionDiscoverers.addFilteredNodes(self, holder, filter, keyFactory, graphView, under, collector);
        return collector;
    }

    private static void addFilteredNodes(@NotNull SidedWireBlockNode self, @NotNull NodeHolder<BlockNode> holder, @Nullable SidedWireConnectionFilter filter, @NotNull LinkKeyFactory keyFactory, @NotNull GraphView graphView, @NotNull class_2338 pos, @NotNull List<HalfLink> collector) {
        Iterator iter = graphView.getNodesAt(pos).iterator();
        while (iter.hasNext()) {
            NodeHolder other = (NodeHolder)iter.next();
            HalfLink link = new HalfLink(keyFactory.createLinkKey(holder, other), other);
            if (!WireConnectionDiscoverers.sidedWireCanConnect(self, holder, link, filter)) continue;
            collector.add(link);
        }
    }

    public static boolean sidedWireCanConnect(@NotNull SidedWireBlockNode self, @NotNull NodeHolder<BlockNode> holder, @NotNull HalfLink link) {
        return WireConnectionDiscoverers.sidedWireCanConnect(self, holder, link, null);
    }

    public static boolean sidedWireCanConnect(@NotNull SidedWireBlockNode self, @NotNull NodeHolder<BlockNode> holder, @NotNull HalfLink link, @Nullable SidedWireConnectionFilter filter) {
        class_2338 pos = holder.getBlockPos();
        class_2350 side = self.getSide();
        class_2338 otherPos = link.other().getBlockPos();
        BlockNode other = link.other().getNode();
        class_2338 posDiff = otherPos.method_10059((class_2382)pos);
        class_2350 posDiffDir = class_2350.method_50026((int)posDiff.method_10263(), (int)posDiff.method_10264(), (int)posDiff.method_10260());
        if (other instanceof SidedWireBlockNode) {
            SidedWireBlockNode otherSidedNode = (SidedWireBlockNode)other;
            class_2350 otherSide = otherSidedNode.getSide();
            if (otherPos.equals((Object)pos)) {
                return !otherSide.method_10166().equals((Object)side.method_10166()) && (filter == null || filter.canConnect(self, holder, otherSide, WireConnectionType.INTERNAL, link)) && self.canConnect(holder, otherSide, WireConnectionType.INTERNAL, link);
            }
            if (posDiffDir != null) {
                return !posDiffDir.method_10166().equals((Object)side.method_10166()) && otherSide.equals((Object)side) && (filter == null || filter.canConnect(self, holder, posDiffDir, WireConnectionType.EXTERNAL, link)) && self.canConnect(holder, posDiffDir, WireConnectionType.EXTERNAL, link);
            }
            class_2338 under = pos.method_10093(side);
            class_2338 underPosDiff = otherPos.method_10059((class_2382)under);
            class_2350 underPosDiffDir = class_2350.method_50026((int)underPosDiff.method_10263(), (int)underPosDiff.method_10264(), (int)underPosDiff.method_10260());
            if (underPosDiffDir != null) {
                return !underPosDiffDir.method_10166().equals((Object)side.method_10166()) && otherSide.equals((Object)underPosDiffDir.method_10153()) && (filter == null || filter.canConnect(self, holder, underPosDiffDir, WireConnectionType.CORNER, link)) && self.canConnect(holder, underPosDiffDir, WireConnectionType.CORNER, link);
            }
            return false;
        }
        if (other instanceof FullWireBlockNode) {
            WireConnectionType type = side.equals((Object)posDiffDir) ? WireConnectionType.UNDER : WireConnectionType.EXTERNAL;
            return posDiffDir != null && !posDiffDir.equals((Object)side.method_10153()) && (filter == null || filter.canConnect(self, holder, posDiffDir, type, link)) && self.canConnect(holder, posDiffDir, type, link);
        }
        if (other instanceof CenterWireBlockNode) {
            return pos.equals((Object)otherPos) && (filter == null || filter.canConnect(self, holder, side.method_10153(), WireConnectionType.ABOVE, link)) && self.canConnect(holder, side.method_10153(), WireConnectionType.ABOVE, link);
        }
        return false;
    }

    @NotNull
    public static Collection<HalfLink> fullBlockFindConnections(@NotNull FullWireBlockNode self, @NotNull NodeHolder<BlockNode> holder) {
        return WireConnectionDiscoverers.fullBlockFindConnections(self, holder, null, EmptyLinkKey.FACTORY);
    }

    @NotNull
    public static Collection<HalfLink> fullBlockFindConnections(@NotNull FullWireBlockNode self, @NotNull NodeHolder<BlockNode> holder, @Nullable FullWireConnectionFilter filter) {
        return WireConnectionDiscoverers.fullBlockFindConnections(self, holder, filter, EmptyLinkKey.FACTORY);
    }

    @NotNull
    public static Collection<HalfLink> fullBlockFindConnections(@NotNull FullWireBlockNode self, @NotNull NodeHolder<BlockNode> holder, @Nullable FullWireConnectionFilter filter, @NotNull LinkKeyFactory keyFactory) {
        GraphView graphView = holder.getGraphWorld();
        class_2338 pos = holder.getBlockPos();
        ArrayList<HalfLink> collector = new ArrayList<HalfLink>();
        for (class_2350 side : class_2350.values()) {
            Iterator iter = graphView.getNodesAt(pos.method_10093(side)).iterator();
            while (iter.hasNext()) {
                NodeHolder other = (NodeHolder)iter.next();
                HalfLink link = new HalfLink(keyFactory.createLinkKey(holder, other), other);
                if (!WireConnectionDiscoverers.fullBlockCanConnect(self, holder, link, filter)) continue;
                collector.add(link);
            }
        }
        return collector;
    }

    public static boolean fullBlockCanConnect(@NotNull FullWireBlockNode self, @NotNull NodeHolder<BlockNode> holder, @NotNull HalfLink link) {
        return WireConnectionDiscoverers.fullBlockCanConnect(self, holder, link, null);
    }

    public static boolean fullBlockCanConnect(@NotNull FullWireBlockNode self, @NotNull NodeHolder<BlockNode> holder, @NotNull HalfLink link, @Nullable FullWireConnectionFilter filter) {
        class_2338 pos = holder.getBlockPos();
        class_2338 otherPos = link.other().getBlockPos();
        BlockNode other = link.other().getNode();
        class_2338 posDiff = otherPos.method_10059((class_2382)pos);
        class_2350 posDiffDir = class_2350.method_50026((int)posDiff.method_10263(), (int)posDiff.method_10264(), (int)posDiff.method_10260());
        if (posDiffDir == null) {
            return false;
        }
        if (other instanceof FullWireBlockNode || other instanceof CenterWireBlockNode) {
            return (filter == null || filter.canConnect(self, holder, posDiffDir, null, link)) && self.canConnect(holder, posDiffDir, null, link);
        }
        if (other instanceof SidedWireBlockNode) {
            SidedWireBlockNode otherSidedNode = (SidedWireBlockNode)other;
            class_2350 otherSide = otherSidedNode.getSide();
            return !otherSide.equals((Object)posDiffDir) && (filter == null || filter.canConnect(self, holder, posDiffDir, otherSide, link)) && self.canConnect(holder, posDiffDir, otherSide, link);
        }
        return false;
    }

    @NotNull
    public static Collection<HalfLink> centerWireFindConnections(@NotNull CenterWireBlockNode self, @NotNull NodeHolder<BlockNode> holder) {
        return WireConnectionDiscoverers.centerWireFindConnections(self, holder, null, EmptyLinkKey.FACTORY);
    }

    @NotNull
    public static Collection<HalfLink> centerWireFindConnections(@NotNull CenterWireBlockNode self, @NotNull NodeHolder<BlockNode> holder, @Nullable CenterWireConnectionFilter filter) {
        return WireConnectionDiscoverers.centerWireFindConnections(self, holder, filter, EmptyLinkKey.FACTORY);
    }

    @NotNull
    public static Collection<HalfLink> centerWireFindConnections(@NotNull CenterWireBlockNode self, @NotNull NodeHolder<BlockNode> holder, @Nullable CenterWireConnectionFilter filter, @NotNull LinkKeyFactory keyFactory) {
        GraphView graphView = holder.getGraphWorld();
        class_2338 pos = holder.getBlockPos();
        ArrayList<HalfLink> collector = new ArrayList<HalfLink>();
        Iterator iter = graphView.getNodesAt(pos).iterator();
        while (iter.hasNext()) {
            NodeHolder other = (NodeHolder)iter.next();
            HalfLink link = new HalfLink(keyFactory.createLinkKey(holder, other), other);
            if (!WireConnectionDiscoverers.centerWireCanConnect(self, holder, link, filter)) continue;
            collector.add(link);
        }
        for (class_2350 external : class_2350.values()) {
            Iterator iter2 = graphView.getNodesAt(pos.method_10093(external)).iterator();
            while (iter2.hasNext()) {
                NodeHolder other = (NodeHolder)iter2.next();
                HalfLink link = new HalfLink(keyFactory.createLinkKey(holder, other), other);
                if (!WireConnectionDiscoverers.centerWireCanConnect(self, holder, link, filter)) continue;
                collector.add(link);
            }
        }
        return collector;
    }

    public static boolean centerWireCanConnect(@NotNull CenterWireBlockNode self, @NotNull NodeHolder<BlockNode> holder, @NotNull HalfLink link) {
        return WireConnectionDiscoverers.centerWireCanConnect(self, holder, link, null);
    }

    public static boolean centerWireCanConnect(@NotNull CenterWireBlockNode self, @NotNull NodeHolder<BlockNode> holder, @NotNull HalfLink link, @Nullable CenterWireConnectionFilter filter) {
        class_2338 pos = holder.getBlockPos();
        class_2338 otherPos = link.other().getBlockPos();
        BlockNode other = link.other().getNode();
        class_2338 posDiff = otherPos.method_10059((class_2382)pos);
        class_2350 posDiffDir = class_2350.method_50026((int)posDiff.method_10263(), (int)posDiff.method_10264(), (int)posDiff.method_10260());
        if (other instanceof CenterWireBlockNode || other instanceof FullWireBlockNode) {
            return posDiffDir != null && (filter == null || filter.canConnect(self, holder, posDiffDir, link)) && self.canConnect(holder, posDiffDir, link);
        }
        if (other instanceof SidedWireBlockNode || other instanceof SidedFaceBlockNode) {
            SidedBlockNode otherSided = (SidedBlockNode)other;
            class_2350 otherSide = otherSided.getSide();
            return pos.equals((Object)otherPos) && (filter == null || filter.canConnect(self, holder, otherSide, link)) && self.canConnect(holder, otherSide, link);
        }
        return false;
    }

    @NotNull
    public static Collection<HalfLink> sidedFaceFindConnections(@NotNull SidedFaceBlockNode self, @NotNull NodeHolder<BlockNode> holder) {
        return WireConnectionDiscoverers.sidedFaceFindConnections(self, holder, null, EmptyLinkKey.FACTORY);
    }

    @NotNull
    public static Collection<HalfLink> sidedFaceFindConnections(@NotNull SidedFaceBlockNode self, @NotNull NodeHolder<BlockNode> holder, @Nullable SidedFaceConnectionFilter filter) {
        return WireConnectionDiscoverers.sidedFaceFindConnections(self, holder, filter, EmptyLinkKey.FACTORY);
    }

    @NotNull
    public static Collection<HalfLink> sidedFaceFindConnections(@NotNull SidedFaceBlockNode self, @NotNull NodeHolder<BlockNode> holder, @Nullable SidedFaceConnectionFilter filter, @NotNull LinkKeyFactory keyFactory) {
        GraphView graphView = holder.getGraphWorld();
        class_2338 pos = holder.getBlockPos();
        ArrayList<HalfLink> collector = new ArrayList<HalfLink>();
        Iterator iter = graphView.getNodesAt(pos).iterator();
        while (iter.hasNext()) {
            NodeHolder other = (NodeHolder)iter.next();
            HalfLink link = new HalfLink(keyFactory.createLinkKey(holder, other), other);
            if (!WireConnectionDiscoverers.sidedFaceCanConnect(self, holder, link, filter)) continue;
            collector.add(link);
        }
        return collector;
    }

    public static boolean sidedFaceCanConnect(@NotNull SidedFaceBlockNode self, @NotNull NodeHolder<BlockNode> holder, @NotNull HalfLink link) {
        return WireConnectionDiscoverers.sidedFaceCanConnect(self, holder, link, null);
    }

    public static boolean sidedFaceCanConnect(@NotNull SidedFaceBlockNode self, @NotNull NodeHolder<BlockNode> holder, @NotNull HalfLink link, @Nullable SidedFaceConnectionFilter filter) {
        class_2338 pos = holder.getBlockPos();
        class_2338 otherPos = link.other().getBlockPos();
        BlockNode other = link.other().getNode();
        class_2350 side = self.getSide();
        if (other instanceof CenterWireBlockNode) {
            return pos.equals((Object)otherPos) && (filter == null || filter.canConnect(self, holder, side.method_10153(), link)) && self.canConnect(holder, side.method_10153(), link);
        }
        return false;
    }
}

