/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.graphlib.api.util.graph;

import com.kneelawk.graphlib.api.util.graph.Link;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class Node<T, L> {
    private final T data;
    private final Set<Link<T, L>> connections;

    public Node(T data) {
        this.data = data;
        this.connections = new LinkedHashSet<Link<T, L>>();
    }

    public T data() {
        return this.data;
    }

    @NotNull
    public Set<Link<T, L>> connections() {
        return this.connections;
    }

    public void onAdded(@NotNull Node<T, L> other) {
    }

    public void onRemoved(@NotNull Node<T, L> other) {
        this.connections.removeIf(link -> link.contains(other));
    }

    public boolean onLink(@NotNull Link<T, L> link) {
        return this.connections.add(link);
    }

    public boolean onUnlink(@NotNull Link<T, L> link) {
        return this.connections.remove(link);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Node that = (Node)obj;
        return Objects.equals(this.data, that.data);
    }

    public int hashCode() {
        return Objects.hash(this.data);
    }

    public String toString() {
        return "Node[node=" + this.data + "]";
    }
}

