/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.graphlib.api.util.graph;

import com.kneelawk.graphlib.api.util.graph.Node;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public record Link<T, L>(@NotNull Node<T, L> first, @NotNull Node<T, L> second, @NotNull L key) {
    public boolean contains(@NotNull Node<T, L> node) {
        return Objects.equals(this.first, node) || Objects.equals(this.second, node);
    }

    @NotNull
    public Node<T, L> other(@NotNull Node<T, L> node) {
        if (Objects.equals(this.first, node)) {
            return this.second;
        }
        return this.first;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Link linkKey = (Link)o;
        if (!this.key.equals(linkKey.key)) {
            return false;
        }
        if (this.first.equals(linkKey.first)) {
            return this.second.equals(linkKey.second);
        }
        if (this.second.equals(linkKey.first)) {
            return this.first.equals(linkKey.second);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = this.first.hashCode();
        result ^= this.second.hashCode();
        result = 31 * result + this.key.hashCode();
        return result;
    }
}

