/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.graphlib.api.util.graph;

import com.kneelawk.graphlib.api.util.graph.Link;
import com.kneelawk.graphlib.api.util.graph.Node;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public final class Graph<T, L>
implements Iterable<Node<T, L>> {
    private final Set<Node<T, L>> nodes = new LinkedHashSet<Node<T, L>>();

    @NotNull
    public Node<T, L> add(T data) {
        Node node = new Node(data);
        this.nodes.forEach((? super T n) -> n.onAdded(node));
        this.nodes.add(node);
        return node;
    }

    public void remove(@NotNull Node<T, L> node) {
        if (this.nodes.contains(node)) {
            this.nodes.remove(node);
            this.nodes.forEach((? super T n) -> n.onRemoved(node));
        }
    }

    @NotNull
    public List<Graph<T, L>> split() {
        Graph<T, L> newGraph;
        ArrayList<Graph<T, L>> result = new ArrayList<Graph<T, L>>();
        int largestGraphSize = 0;
        int largestGraphIndex = 0;
        LinkedHashSet<Node<T, L>> toBeChecked = new LinkedHashSet<Node<T, L>>(this.nodes);
        LinkedHashSet<Node<T, L>> connected = new LinkedHashSet<Node<T, L>>();
        while (!toBeChecked.isEmpty()) {
            connected.clear();
            this.descend(connected, toBeChecked, (Node)toBeChecked.iterator().next());
            if (toBeChecked.isEmpty()) continue;
            newGraph = new Graph<T, L>();
            this.moveBulkUnchecked(newGraph, connected);
            if (newGraph.size() > largestGraphSize) {
                largestGraphSize = newGraph.size();
                largestGraphIndex = result.size();
            }
            result.add(newGraph);
        }
        if (connected.size() < largestGraphSize) {
            newGraph = new Graph<T, L>();
            this.moveBulkUnchecked(newGraph, connected);
            Graph<T, L> largestGraph = result.set(largestGraphIndex, newGraph);
            this.join(largestGraph);
        }
        return result;
    }

    private void descend(@NotNull Set<Node<T, L>> connected, @NotNull Set<Node<T, L>> toBeChecked, @NotNull Node<T, L> node) {
        ArrayDeque stack = new ArrayDeque();
        stack.push(node);
        connected.add(node);
        toBeChecked.remove(node);
        while (!stack.isEmpty()) {
            Node cur = (Node)stack.pop();
            for (Link link : cur.connections()) {
                Node a = link.other(cur);
                if (!toBeChecked.contains(a)) continue;
                stack.push(a);
                connected.add(a);
                toBeChecked.remove(a);
            }
        }
    }

    public void moveBulkUnchecked(@NotNull Graph<T, L> into, @NotNull Set<Node<T, L>> nodes) {
        this.nodes.removeAll(nodes);
        into.nodes.addAll(nodes);
    }

    public void join(@NotNull Graph<T, L> other) {
        this.nodes.addAll(other.nodes);
        other.nodes.clear();
    }

    @NotNull
    public Link<T, L> link(@NotNull Node<T, L> a, @NotNull Node<T, L> b, @NotNull L linkKey) {
        Link<T, L> link = new Link<T, L>(a, b, linkKey);
        a.onLink(link);
        b.onLink(link);
        return link;
    }

    public boolean link(@NotNull Link<T, L> newLink) {
        return newLink.first().onLink(newLink) & newLink.second().onLink(newLink);
    }

    public boolean unlink(@NotNull Node<T, L> a, @NotNull Node<T, L> b, @NotNull L linkKey) {
        Link<T, L> link1 = new Link<T, L>(a, b, linkKey);
        return a.onUnlink(link1) & b.onUnlink(link1);
    }

    public boolean unlink(@NotNull Link<T, L> link) {
        return link.first().onUnlink(link) & link.second().onUnlink(link);
    }

    public boolean contains(@NotNull Node<T, L> node) {
        return this.nodes.contains(node);
    }

    @SafeVarargs
    public final boolean contains(Node<T, L> ... nodes) {
        for (Node<T, L> node : nodes) {
            if (this.contains(node)) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public Iterator<Node<T, L>> iterator() {
        return this.nodes.iterator();
    }

    @Override
    public void forEach(@NotNull Consumer<? super Node<T, L>> action) {
        this.nodes.forEach(action);
    }

    @Override
    @NotNull
    public Spliterator<Node<T, L>> spliterator() {
        return this.nodes.spliterator();
    }

    @NotNull
    public Stream<Node<T, L>> stream() {
        return this.nodes.stream();
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    public int size() {
        return this.nodes.size();
    }
}

