/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.graphlib.api.util;

import alexiil.mc.lib.net.IMsgReadCtx;
import alexiil.mc.lib.net.IMsgWriteCtx;
import alexiil.mc.lib.net.InvalidInputDataException;
import alexiil.mc.lib.net.NetByteBuf;
import com.kneelawk.graphlib.api.graph.GraphUniverse;
import com.kneelawk.graphlib.api.graph.user.BlockNode;
import com.kneelawk.graphlib.api.graph.user.BlockNodePacketDecoder;
import com.kneelawk.graphlib.api.graph.user.BlockNodeType;
import com.kneelawk.graphlib.impl.GLLog;
import com.kneelawk.graphlib.impl.net.GLNet;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record NodePos(@NotNull class_2338 pos, @NotNull BlockNode node) {
    public NodePos(@NotNull class_2338 pos, @NotNull BlockNode node) {
        this.pos = pos.method_10062();
        this.node = node;
    }

    public void toNbt(@NotNull class_2487 nbt) {
        nbt.method_10569("x", this.pos.method_10263());
        nbt.method_10569("y", this.pos.method_10264());
        nbt.method_10569("z", this.pos.method_10260());
        nbt.method_10582("type", this.node.getType().getId().toString());
        class_2520 nodeNbt = this.node.toTag();
        if (nodeNbt != null) {
            nbt.method_10566("node", nodeNbt);
        }
    }

    @NotNull
    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        this.toNbt(nbt);
        return nbt;
    }

    public void toPacket(@NotNull NetByteBuf buf, @NotNull IMsgWriteCtx ctx) {
        buf.writeBlockPos(this.pos);
        buf.writeVarUnsignedInt(GLNet.ID_CACHE.getId(ctx.getConnection(), (Object)this.node.getType().getId()));
        this.node.toPacket(buf, ctx);
    }

    @Nullable
    public static NodePos fromNbt(@NotNull class_2487 nbt, @NotNull GraphUniverse universe) {
        class_2338 pos = new class_2338(nbt.method_10550("x"), nbt.method_10550("y"), nbt.method_10550("z"));
        class_2960 typeId = new class_2960(nbt.method_10558("type"));
        BlockNodeType type = universe.getNodeType(typeId);
        if (type == null) {
            GLLog.warn("Unable to decode unknown block node type id {} in universe {}", (Object)typeId, (Object)universe.getId());
            return null;
        }
        BlockNode node = type.getDecoder().decode(nbt.method_10580("node"));
        if (node == null) {
            GLLog.warn("Failed to decode block node {}", (Object)type.getId());
            return null;
        }
        return new NodePos(pos, node);
    }

    @NotNull
    public static NodePos fromPacket(@NotNull NetByteBuf buf, @NotNull IMsgReadCtx ctx, @NotNull GraphUniverse universe) throws InvalidInputDataException {
        class_2338 pos = buf.method_10811();
        int idInt = buf.readVarUnsignedInt();
        class_2960 typeId = (class_2960)GLNet.ID_CACHE.getObj(ctx.getConnection(), idInt);
        if (typeId == null) {
            GLLog.warn("Unable to decode block node type id from unknown identifier int {} @ {}", (Object)idInt, (Object)pos);
            throw new InvalidInputDataException("Unable to decode block node type id from unknown identifier int " + idInt + " @ " + pos);
        }
        BlockNodeType type = universe.getNodeType(typeId);
        if (type == null) {
            GLLog.warn("Unable to decode unknown block node type id {} @ {} in universe {}", typeId, pos, universe.getId());
            throw new InvalidInputDataException("Unable to decode unknown block node type id " + typeId + " @ " + pos + " in universe " + universe.getId());
        }
        BlockNodePacketDecoder decoder = type.getPacketDecoder();
        if (decoder == null) {
            GLLog.error("Tried to decode block node {} @ {} in universe {} but it has no packet decoder.", type.getId(), pos, universe.getId());
            throw new InvalidInputDataException("Tried to decode block node " + type.getId() + " @ " + pos + " in universe " + universe.getId() + " but it has no packet decoder.");
        }
        BlockNode node = decoder.decode(buf, ctx);
        return new NodePos(pos, node);
    }
}

