/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.graphlib.api.util;

import alexiil.mc.lib.net.IMsgReadCtx;
import alexiil.mc.lib.net.IMsgWriteCtx;
import alexiil.mc.lib.net.InvalidInputDataException;
import alexiil.mc.lib.net.NetByteBuf;
import com.kneelawk.graphlib.api.graph.GraphUniverse;
import com.kneelawk.graphlib.api.graph.user.BlockNode;
import com.kneelawk.graphlib.api.graph.user.LinkKey;
import com.kneelawk.graphlib.api.graph.user.LinkKeyPacketDecoder;
import com.kneelawk.graphlib.api.graph.user.LinkKeyType;
import com.kneelawk.graphlib.api.util.NodePos;
import com.kneelawk.graphlib.impl.GLLog;
import com.kneelawk.graphlib.impl.net.GLNet;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record LinkPos(@NotNull NodePos first, @NotNull NodePos second, @NotNull LinkKey key) {
    public LinkPos(@NotNull class_2338 firstPos, @NotNull BlockNode firstNode, @NotNull class_2338 secondPos, @NotNull BlockNode secondNode, @NotNull LinkKey key) {
        this(new NodePos(firstPos, firstNode), new NodePos(secondPos, secondNode), key);
    }

    public NodePos other(@NotNull NodePos pos) {
        if (this.first.equals(pos)) {
            return this.second;
        }
        return this.first;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LinkPos linkKey = (LinkPos)o;
        if (!this.key.equals(linkKey.key)) {
            return false;
        }
        if (this.first.equals(linkKey.first)) {
            return this.second.equals(linkKey.second);
        }
        if (this.second.equals(linkKey.first)) {
            return this.first.equals(linkKey.second);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = this.first.hashCode();
        result ^= this.second.hashCode();
        result = 31 * result + this.key.hashCode();
        return result;
    }

    public void toNbt(@NotNull class_2487 nbt) {
        nbt.method_10566("first", (class_2520)this.first.toNbt());
        nbt.method_10566("second", (class_2520)this.second.toNbt());
        nbt.method_10582("keyType", this.key.getType().getId().toString());
        class_2520 keyNbt = this.key.toTag();
        if (keyNbt != null) {
            nbt.method_10566("key", keyNbt);
        }
    }

    @NotNull
    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        this.toNbt(nbt);
        return nbt;
    }

    public void toPacket(@NotNull NetByteBuf buf, @NotNull IMsgWriteCtx ctx) {
        this.first.toPacket(buf, ctx);
        this.second.toPacket(buf, ctx);
        buf.writeVarUnsignedInt(GLNet.ID_CACHE.getId(ctx.getConnection(), (Object)this.key.getType().getId()));
        this.key.toPacket(buf, ctx);
    }

    @Nullable
    public static LinkPos fromNbt(@NotNull class_2487 nbt, @NotNull GraphUniverse universe) {
        NodePos first = NodePos.fromNbt(nbt.method_10562("first"), universe);
        if (first == null) {
            return null;
        }
        NodePos second = NodePos.fromNbt(nbt.method_10562("second"), universe);
        if (second == null) {
            return null;
        }
        class_2960 typeId = new class_2960(nbt.method_10558("keyType"));
        LinkKeyType type = universe.getLinkKeyType(typeId);
        if (type == null) {
            return null;
        }
        LinkKey key = type.getDecoder().decode(nbt.method_10580("key"));
        if (key == null) {
            return null;
        }
        return new LinkPos(first, second, key);
    }

    @NotNull
    public static LinkPos fromPacket(@NotNull NetByteBuf buf, @NotNull IMsgReadCtx ctx, @NotNull GraphUniverse universe) throws InvalidInputDataException {
        NodePos first = NodePos.fromPacket(buf, ctx, universe);
        NodePos second = NodePos.fromPacket(buf, ctx, universe);
        int idInt = buf.readVarUnsignedInt();
        class_2960 typeId = (class_2960)GLNet.ID_CACHE.getObj(ctx.getConnection(), idInt);
        if (typeId == null) {
            GLLog.warn("Unable to decode link key type id from unknown identifier int {} @ {}-{}", idInt, first, second);
            throw new InvalidInputDataException("Unable to decode link key type id from unknown identifier int " + idInt + " @ " + first + "-" + second);
        }
        LinkKeyType type = universe.getLinkKeyType(typeId);
        if (type == null) {
            GLLog.warn("Unable to decode unknown link key type id {} @ {}-{} in universe {}", typeId, first, second, universe.getId());
            throw new InvalidInputDataException("Unable to decode unknown link key type id " + typeId + " @ " + first + "-" + second + " in universe " + universe.getId());
        }
        LinkKeyPacketDecoder decoder = type.getPacketDecoder();
        if (decoder == null) {
            GLLog.error("Tried to decode link key {} @ {}-{} in universe {} but it has no packet decoder.", typeId, first, second, universe.getId());
            throw new InvalidInputDataException("Tried to decode link key " + typeId + " @ " + first + "-" + second + " in universe " + universe.getId() + " but it has no packet decoder.");
        }
        LinkKey key = decoder.decode(buf, ctx);
        return new LinkPos(first, second, key);
    }
}

