/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.graphlib.api.util;

public final class ColorUtils {
    private ColorUtils() {
    }

    public static int float2Argb(float red, float green, float blue, float alpha) {
        return (int)(blue * 255.0f + 0.0f) & 0xFF | ((int)(green * 255.0f + 0.0f) & 0xFF) << 8 | ((int)(red * 255.0f + 0.0f) & 0xFF) << 16 | ((int)(alpha * 255.0f + 0.0f) & 0xFF) << 24;
    }

    public static int hsba2Argb(float hue, float saturation, float brightness, float alpha) {
        if (saturation == 0.0f) {
            return ColorUtils.float2Argb(brightness, brightness, brightness, alpha);
        }
        float sector = hue % 1.0f * 6.0f;
        if (sector < 0.0f) {
            sector += 6.0f;
        }
        float offset = sector - (float)((int)sector);
        float off = brightness * (1.0f - saturation);
        float fadeOut = brightness * (1.0f - saturation * offset);
        float fadeIn = brightness * (1.0f - saturation * (1.0f - offset));
        return switch ((int)sector % 6) {
            case 0 -> ColorUtils.float2Argb(brightness, fadeIn, off, alpha);
            case 1 -> ColorUtils.float2Argb(fadeOut, brightness, off, alpha);
            case 2 -> ColorUtils.float2Argb(off, brightness, fadeIn, alpha);
            case 3 -> ColorUtils.float2Argb(off, fadeOut, brightness, alpha);
            case 4 -> ColorUtils.float2Argb(fadeIn, off, brightness, alpha);
            case 5 -> ColorUtils.float2Argb(brightness, off, fadeOut, alpha);
            default -> throw new AssertionError();
        };
    }
}

