/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.graphlib.api.util;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import net.minecraft.class_1923;
import org.jetbrains.annotations.NotNull;

public abstract class ChunkUnloadTimer {
    protected final long maxAge;
    protected long tickAge;
    protected final LongSet worldLoadedChunks = new LongOpenHashSet();

    public ChunkUnloadTimer(long maxAge) {
        this.maxAge = maxAge;
        this.tickAge = 0L;
    }

    public void onWorldChunkLoad(@NotNull class_1923 pos) {
        this.worldLoadedChunks.add(pos.method_8324());
        this.removeUnloadMark(pos);
    }

    protected abstract void removeUnloadMark(@NotNull class_1923 var1);

    public void onWorldChunkUnload(@NotNull class_1923 pos) {
        this.worldLoadedChunks.remove(pos.method_8324());
        this.markForUnloading(pos);
    }

    protected abstract void markForUnloading(@NotNull class_1923 var1);

    public boolean isWorldChunkLoaded(@NotNull class_1923 pos) {
        return this.worldLoadedChunks.contains(pos.method_8324());
    }

    public void tick() {
        ++this.tickAge;
    }
}

