/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.graphlib.api.util;

import com.kneelawk.graphlib.api.util.ChunkUnloadTimer;
import it.unimi.dsi.fastutil.longs.Long2LongLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1923;
import net.minecraft.class_4076;
import org.jetbrains.annotations.NotNull;

public class ChunkSectionUnloadTimer
extends ChunkUnloadTimer {
    private final int bottomSectionCoord;
    private final int topSectionCoord;
    private final LongSet loadedChunks = new LongOpenHashSet();
    private final Long2LongMap toUnload = new Long2LongLinkedOpenHashMap();

    public ChunkSectionUnloadTimer(int bottomSectionCoord, int topSectionCoord, long maxAge) {
        super(maxAge);
        this.bottomSectionCoord = bottomSectionCoord;
        this.topSectionCoord = topSectionCoord;
    }

    @Override
    protected void removeUnloadMark(@NotNull class_1923 pos) {
        for (int y = this.bottomSectionCoord; y < this.topSectionCoord; ++y) {
            this.toUnload.remove(class_4076.method_18685((int)pos.field_9181, (int)y, (int)pos.field_9180));
        }
    }

    @Override
    protected void markForUnloading(@NotNull class_1923 pos) {
        for (int y = this.bottomSectionCoord; y < this.topSectionCoord; ++y) {
            long longPos = class_4076.method_18685((int)pos.field_9181, (int)y, (int)pos.field_9180);
            if (!this.loadedChunks.contains(longPos)) continue;
            this.toUnload.put(longPos, this.tickAge + this.maxAge);
        }
    }

    public boolean isChunkLoaded(@NotNull class_4076 pos) {
        return this.loadedChunks.contains(pos.method_18694());
    }

    public void onChunkUse(@NotNull class_4076 pos) {
        this.loadedChunks.add(pos.method_18694());
        if (!this.worldLoadedChunks.contains(pos.method_18692().method_8324())) {
            this.toUnload.put(pos.method_18694(), this.tickAge + this.maxAge);
        }
    }

    public void onChunkUnload(@NotNull class_4076 pos) {
        this.loadedChunks.remove(pos.method_18694());
        this.toUnload.remove(pos.method_18694());
    }

    public List<class_4076> chunksToUnload() {
        return this.toUnload.keySet().longStream().filter(longPos -> this.toUnload.get(longPos) < this.tickAge).mapToObj(class_4076::method_18677).collect(Collectors.toList());
    }
}

