/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.graphlib.api.util;

import com.kneelawk.graphlib.api.graph.NodeHolder;
import com.kneelawk.graphlib.api.graph.user.BlockNode;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class CacheCategory<T extends BlockNode> {
    private final Class<T> nodeClass;
    private final Predicate<NodeHolder<T>> predicate;

    private CacheCategory(Class<T> nodeClass, Predicate<NodeHolder<T>> predicate) {
        this.nodeClass = nodeClass;
        this.predicate = predicate;
    }

    @NotNull
    public Class<T> getNodeClass() {
        return this.nodeClass;
    }

    public boolean matches(@NotNull NodeHolder<?> holder) {
        return holder.canCast(this.nodeClass) && this.predicate.test(holder.cast(this.nodeClass));
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static <T extends BlockNode> CacheCategory<T> of(Class<T> nodeClass, Predicate<NodeHolder<T>> predicate) {
        return new CacheCategory<T>(nodeClass, predicate);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <T extends BlockNode> CacheCategory<T> of(Class<T> nodeClass) {
        return new CacheCategory<T>(nodeClass, holder -> true);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static CacheCategory<BlockNode> of(Predicate<NodeHolder<BlockNode>> predicate) {
        return new CacheCategory<BlockNode>(BlockNode.class, predicate);
    }
}

