/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.graphlib.api.graph.user;

import com.kneelawk.graphlib.api.graph.user.PlayerSyncFilter;
import com.kneelawk.graphlib.api.util.CacheCategory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SyncProfile {
    private final boolean enabled;
    @NotNull
    private final PlayerSyncFilter playerFilter;
    @Nullable
    private final CacheCategory<?> nodeFilter;
    @NotNull
    public static final SyncProfile SYNC_NOTHING = new SyncProfile(false, player -> false, null);
    @NotNull
    public static final SyncProfile SYNC_EVERYTHING = new SyncProfile(true, player -> true, null);

    private SyncProfile(boolean enabled, @NotNull PlayerSyncFilter playerFilter, @Nullable CacheCategory<?> nodeFilter) {
        this.enabled = enabled;
        this.playerFilter = playerFilter;
        this.nodeFilter = nodeFilter;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public PlayerSyncFilter getPlayerFilter() {
        return this.playerFilter;
    }

    public CacheCategory<?> getNodeFilter() {
        return this.nodeFilter;
    }

    @NotNull
    public static SyncProfile of(@NotNull PlayerSyncFilter playerFilter, @NotNull CacheCategory<?> nodeFilter) {
        return new SyncProfile(true, playerFilter, nodeFilter);
    }

    @NotNull
    public static SyncProfile of(@NotNull PlayerSyncFilter playerFilter) {
        return new SyncProfile(true, playerFilter, null);
    }

    @NotNull
    public static SyncProfile of(@NotNull CacheCategory<?> nodeFilter) {
        return new SyncProfile(true, player -> true, nodeFilter);
    }
}

