/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.graphlib.api.graph.user;

import com.kneelawk.graphlib.api.graph.BlockGraph;
import com.kneelawk.graphlib.api.graph.user.GraphEntity;
import com.kneelawk.graphlib.api.graph.user.GraphEntityDecoder;
import com.kneelawk.graphlib.api.graph.user.GraphEntityFactory;
import com.kneelawk.graphlib.api.graph.user.GraphEntityPacketDecoder;
import com.kneelawk.graphlib.api.graph.user.GraphEntitySplitter;
import com.kneelawk.graphlib.api.util.ObjectType;
import java.util.function.Supplier;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GraphEntityType<G extends GraphEntity<G>>
implements ObjectType {
    @NotNull
    private final class_2960 id;
    @NotNull
    private final GraphEntityFactory factory;
    @NotNull
    private final GraphEntityDecoder decoder;
    @NotNull
    private final GraphEntitySplitter<G> splitter;
    @Nullable
    private final GraphEntityPacketDecoder packetDecoder;

    private GraphEntityType(@NotNull class_2960 id, @NotNull GraphEntityFactory factory, @NotNull GraphEntityDecoder decoder, @NotNull GraphEntitySplitter<G> splitter, @Nullable GraphEntityPacketDecoder packetDecoder) {
        this.id = id;
        this.factory = factory;
        this.decoder = decoder;
        this.splitter = splitter;
        this.packetDecoder = packetDecoder;
    }

    @Override
    @NotNull
    public class_2960 getId() {
        return this.id;
    }

    @NotNull
    public GraphEntityFactory getFactory() {
        return this.factory;
    }

    @NotNull
    public GraphEntityDecoder getDecoder() {
        return this.decoder;
    }

    @NotNull
    public GraphEntitySplitter<G> getSplitter() {
        return this.splitter;
    }

    public GraphEntityPacketDecoder getPacketDecoder() {
        return this.packetDecoder;
    }

    @ApiStatus.Internal
    public void merge(GraphEntity<?> into, GraphEntity<?> from) {
        into.merge(from);
    }

    @ApiStatus.Internal
    @NotNull
    public GraphEntity<?> splitNew(@NotNull GraphEntity<?> original, @NotNull BlockGraph originalGraph, @NotNull BlockGraph newGraph) {
        return this.splitter.splitNew(original, originalGraph, newGraph);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GraphEntityType that = (GraphEntityType)o;
        return this.id.equals((Object)that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "GraphEntityType{id=" + this.id + "}";
    }

    @Contract(value="_, _, _, _, _ -> new", pure=true)
    @NotNull
    public static <G extends GraphEntity<G>> GraphEntityType<G> of(@NotNull class_2960 id, @NotNull GraphEntityFactory factory, @NotNull GraphEntityDecoder decoder, @NotNull GraphEntitySplitter<G> splitter, @Nullable GraphEntityPacketDecoder packetDecoder) {
        return new GraphEntityType<G>(id, factory, decoder, splitter, packetDecoder);
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    @NotNull
    public static <G extends GraphEntity<G>> GraphEntityType<G> of(@NotNull class_2960 id, @NotNull GraphEntityFactory factory, @NotNull GraphEntityDecoder decoder, @NotNull GraphEntitySplitter<G> splitter) {
        return new GraphEntityType<G>(id, factory, decoder, splitter, null);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static <G extends GraphEntity<G>> GraphEntityType<G> of(@NotNull class_2960 id, @NotNull Supplier<GraphEntity<G>> supplier) {
        return new GraphEntityType<GraphEntity>(id, supplier::get, tag -> (GraphEntity)supplier.get(), (original, originalGraph, newGraph) -> (GraphEntity)supplier.get(), (buf, msgCtx) -> (GraphEntity)supplier.get());
    }
}

