/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.graphlib.api.graph;

import com.kneelawk.graphlib.api.graph.BlockGraph;
import com.kneelawk.graphlib.api.graph.GraphView;
import com.kneelawk.graphlib.api.graph.LinkHolder;
import com.kneelawk.graphlib.api.graph.SnapshotNode;
import com.kneelawk.graphlib.api.graph.user.BlockNode;
import com.kneelawk.graphlib.api.graph.user.LinkKey;
import com.kneelawk.graphlib.api.graph.user.NodeEntity;
import com.kneelawk.graphlib.api.util.NodePos;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface NodeHolder<N extends BlockNode> {
    @NotNull
    public NodePos getPos();

    @NotNull
    public class_2338 getBlockPos();

    @NotNull
    public N getNode();

    public long getGraphId();

    public class_1937 getBlockWorld();

    public GraphView getGraphWorld();

    @NotNull
    public Collection<LinkHolder<LinkKey>> getConnections();

    @NotNull
    public <K extends LinkKey> Stream<LinkHolder<K>> getConnectionsOfType(Class<K> var1);

    @NotNull
    public <K extends LinkKey> Stream<LinkHolder<K>> getConnectionsThatMatch(Class<K> var1, Predicate<K> var2);

    @NotNull
    public SnapshotNode<N> toSnapshot();

    @Nullable
    default public NodeEntity getNodeEntity() {
        BlockGraph graph = this.getGraphWorld().getGraph(this.getGraphId());
        if (graph == null) {
            return null;
        }
        return graph.getNodeEntity(this.getPos());
    }

    @Nullable
    default public <E extends NodeEntity> E getNodeEntity(Class<E> entityClass) {
        NodeEntity entity = this.getNodeEntity();
        if (entityClass.isInstance(entity)) {
            return (E)((NodeEntity)entityClass.cast(entity));
        }
        return null;
    }

    @NotNull
    default public class_2680 getBlockState() {
        return this.getBlockWorld().method_8320(this.getBlockPos());
    }

    @Nullable
    default public class_2586 getBlockEntity() {
        return this.getBlockWorld().method_8321(this.getBlockPos());
    }

    public boolean canCast(Class<?> var1);

    public <R extends BlockNode> NodeHolder<R> cast(Class<R> var1) throws ClassCastException;
}

