/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.graphlib.api.graph;

import com.kneelawk.graphlib.api.graph.BlockGraph;
import com.kneelawk.graphlib.api.graph.GraphView;
import com.kneelawk.graphlib.api.graph.NodeHolder;
import com.kneelawk.graphlib.api.graph.user.BlockNode;
import com.kneelawk.graphlib.api.graph.user.LinkEntity;
import com.kneelawk.graphlib.api.graph.user.LinkKey;
import com.kneelawk.graphlib.api.graph.user.NodeEntity;
import com.kneelawk.graphlib.api.util.HalfLink;
import com.kneelawk.graphlib.api.util.LinkPos;
import com.kneelawk.graphlib.api.util.NodePos;
import java.util.Objects;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface LinkHolder<K extends LinkKey> {
    @NotNull
    public class_1937 getBlockWorld();

    @NotNull
    public GraphView getGraphWorld();

    @NotNull
    public NodeHolder<BlockNode> getFirst();

    @NotNull
    public NodeHolder<BlockNode> getSecond();

    @NotNull
    public K getKey();

    default public boolean contains(@NotNull NodeHolder<BlockNode> node) {
        return Objects.equals(this.getFirst(), node) || Objects.equals(this.getSecond(), node);
    }

    @NotNull
    default public NodeHolder<BlockNode> other(@NotNull NodeHolder<BlockNode> node) {
        NodeHolder<BlockNode> first = this.getFirst();
        if (Objects.equals(first, node)) {
            return this.getSecond();
        }
        return first;
    }

    @NotNull
    default public NodeHolder<BlockNode> other(@NotNull NodePos node) {
        NodeHolder<BlockNode> first = this.getFirst();
        if (Objects.equals(first.getPos(), node)) {
            return this.getSecond();
        }
        return first;
    }

    default public long getGraphId() {
        return this.getFirst().getGraphId();
    }

    @NotNull
    default public LinkPos getPos() {
        return new LinkPos(this.getFirst().getPos(), this.getSecond().getPos(), (LinkKey)this.getKey());
    }

    @NotNull
    default public class_2338 getFirstBlockPos() {
        return this.getFirst().getBlockPos();
    }

    @NotNull
    default public class_2338 getSecondBlockPos() {
        return this.getSecond().getBlockPos();
    }

    @NotNull
    default public class_2680 getFirstBlockState() {
        return this.getBlockWorld().method_8320(this.getFirstBlockPos());
    }

    @NotNull
    default public class_2680 getSecondBlockState() {
        return this.getBlockWorld().method_8320(this.getSecondBlockPos());
    }

    @Nullable
    default public class_2586 getFirstBlockEntity() {
        return this.getBlockWorld().method_8321(this.getFirstBlockPos());
    }

    @Nullable
    default public class_2586 getSecondBlockEntity() {
        return this.getBlockWorld().method_8321(this.getSecondBlockPos());
    }

    @NotNull
    default public BlockNode getFirstNode() {
        return this.getFirst().getNode();
    }

    @NotNull
    default public BlockNode getSecondNode() {
        return this.getSecond().getNode();
    }

    @Nullable
    default public NodeEntity getFirstNodeEntity() {
        BlockGraph graph = this.getGraphWorld().getGraph(this.getFirst().getGraphId());
        if (graph != null) {
            return graph.getNodeEntity(this.getFirst().getPos());
        }
        return null;
    }

    @Nullable
    default public <T extends NodeEntity> T getFirstNodeEntity(Class<T> entityClass) {
        NodeEntity entity = this.getFirstNodeEntity();
        if (entityClass.isInstance(entity)) {
            return (T)((NodeEntity)entityClass.cast(entity));
        }
        return null;
    }

    @Nullable
    default public NodeEntity getSecondNodeEntity() {
        BlockGraph graph = this.getGraphWorld().getGraph(this.getSecond().getGraphId());
        if (graph != null) {
            return graph.getNodeEntity(this.getSecond().getPos());
        }
        return null;
    }

    @Nullable
    default public <T extends NodeEntity> T getSecondNodeEntity(Class<T> entityClass) {
        NodeEntity entity = this.getSecondNodeEntity();
        if (entityClass.isInstance(entity)) {
            return (T)((NodeEntity)entityClass.cast(entity));
        }
        return null;
    }

    @Nullable
    default public LinkEntity getLinkEntity() {
        BlockGraph graph = this.getGraphWorld().getGraph(this.getFirst().getGraphId());
        if (graph != null) {
            return graph.getLinkEntity(this.getPos());
        }
        return null;
    }

    @Nullable
    default public <T extends LinkEntity> T getLinkEntity(Class<T> entityClass) {
        LinkEntity entity = this.getLinkEntity();
        if (entityClass.isInstance(entity)) {
            return (T)((LinkEntity)entityClass.cast(entity));
        }
        return null;
    }

    @NotNull
    default public HalfLink toHalfLink(@NotNull NodeHolder<BlockNode> perspective) {
        return new HalfLink((LinkKey)this.getKey(), this.other(perspective));
    }
}

