/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.graphlib.api.graph;

import com.kneelawk.graphlib.api.graph.BlockGraph;
import com.kneelawk.graphlib.api.graph.GraphView;
import com.kneelawk.graphlib.api.graph.LinkHolder;
import com.kneelawk.graphlib.api.graph.NodeHolder;
import com.kneelawk.graphlib.api.graph.user.BlockNode;
import com.kneelawk.graphlib.api.graph.user.LinkKey;
import com.kneelawk.graphlib.api.graph.user.NodeEntity;
import com.kneelawk.graphlib.api.util.LinkPos;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface LinkEntityContext {
    public void markDirty();

    @NotNull
    public LinkHolder<LinkKey> getHolder();

    @NotNull
    public class_1937 getBlockWorld();

    @NotNull
    public GraphView getGraphWorld();

    @NotNull
    default public NodeHolder<BlockNode> getFirst() {
        return this.getHolder().getFirst();
    }

    @NotNull
    default public NodeHolder<BlockNode> getSecond() {
        return this.getHolder().getSecond();
    }

    default public long getGraphId() {
        return this.getHolder().getGraphId();
    }

    default public LinkPos getPos() {
        return this.getHolder().getPos();
    }

    @NotNull
    default public class_2338 getFirstBlockPos() {
        return this.getHolder().getFirst().getBlockPos();
    }

    @NotNull
    default public class_2338 getSecondBlockPos() {
        return this.getHolder().getSecond().getBlockPos();
    }

    @NotNull
    default public class_2680 getFirstBlockState() {
        return this.getBlockWorld().method_8320(this.getFirstBlockPos());
    }

    @NotNull
    default public class_2680 getSecondBlockState() {
        return this.getBlockWorld().method_8320(this.getSecondBlockPos());
    }

    @Nullable
    default public class_2586 getFirstBlockEntity() {
        return this.getBlockWorld().method_8321(this.getFirstBlockPos());
    }

    @Nullable
    default public class_2586 getSecondBlockEntity() {
        return this.getBlockWorld().method_8321(this.getSecondBlockPos());
    }

    @NotNull
    default public BlockNode getFirstNode() {
        return this.getHolder().getFirst().getNode();
    }

    @NotNull
    default public BlockNode getSecondNode() {
        return this.getHolder().getSecond().getNode();
    }

    @Nullable
    default public NodeEntity getFirstNodeEntity() {
        BlockGraph graph = this.getGraphWorld().getGraph(this.getHolder().getFirst().getGraphId());
        if (graph != null) {
            return graph.getNodeEntity(this.getHolder().getFirst().getPos());
        }
        return null;
    }

    @Nullable
    default public <T extends NodeEntity> T getFirstNodeEntity(Class<T> entityClass) {
        NodeEntity entity = this.getFirstNodeEntity();
        if (entityClass.isInstance(entity)) {
            return (T)((NodeEntity)entityClass.cast(entity));
        }
        return null;
    }

    @Nullable
    default public NodeEntity getSecondNodeEntity() {
        BlockGraph graph = this.getGraphWorld().getGraph(this.getHolder().getSecond().getGraphId());
        if (graph != null) {
            return graph.getNodeEntity(this.getHolder().getSecond().getPos());
        }
        return null;
    }

    @Nullable
    default public <T extends NodeEntity> T getSecondNodeEntity(Class<T> entityClass) {
        NodeEntity entity = this.getSecondNodeEntity();
        if (entityClass.isInstance(entity)) {
            return (T)((NodeEntity)entityClass.cast(entity));
        }
        return null;
    }
}

