/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.graphlib.api.graph;

import com.kneelawk.graphlib.api.graph.BlockGraph;
import com.kneelawk.graphlib.api.graph.GraphUniverse;
import com.kneelawk.graphlib.api.graph.LinkHolder;
import com.kneelawk.graphlib.api.graph.NodeHolder;
import com.kneelawk.graphlib.api.graph.user.BlockNode;
import com.kneelawk.graphlib.api.graph.user.LinkEntity;
import com.kneelawk.graphlib.api.graph.user.LinkKey;
import com.kneelawk.graphlib.api.graph.user.NodeEntity;
import com.kneelawk.graphlib.api.graph.user.SidedBlockNode;
import com.kneelawk.graphlib.api.util.LinkPos;
import com.kneelawk.graphlib.api.util.NodePos;
import com.kneelawk.graphlib.api.util.SidedPos;
import java.util.Objects;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_4076;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface GraphView {
    @NotNull
    public GraphUniverse getUniverse();

    @NotNull
    public class_1937 getWorld();

    @NotNull
    public Stream<NodeHolder<BlockNode>> getNodesAt(@NotNull class_2338 var1);

    @NotNull
    public Stream<NodeHolder<SidedBlockNode>> getNodesAt(@NotNull SidedPos var1);

    @Nullable
    public NodeHolder<BlockNode> getNodeAt(@NotNull NodePos var1);

    public boolean nodeExistsAt(@NotNull NodePos var1);

    @Nullable
    public BlockGraph getGraphForNode(@NotNull NodePos var1);

    @Nullable
    public NodeEntity getNodeEntity(@NotNull NodePos var1);

    public boolean linkExistsAt(@NotNull LinkPos var1);

    @Nullable
    public LinkHolder<LinkKey> getLinkAt(@NotNull LinkPos var1);

    @Nullable
    public LinkEntity getLinkEntity(@NotNull LinkPos var1);

    @NotNull
    public LongStream getAllGraphIdsAt(@NotNull class_2338 var1);

    @NotNull
    default public Stream<BlockGraph> getAllGraphsAt(@NotNull class_2338 pos) {
        return this.getAllGraphIdsAt(pos).mapToObj(this::getGraph).filter(Objects::nonNull);
    }

    @NotNull
    public Stream<BlockGraph> getLoadedGraphsAt(@NotNull class_2338 var1);

    @Nullable
    public BlockGraph getGraph(long var1);

    @NotNull
    public LongStream getAllGraphIdsInChunkSection(@NotNull class_4076 var1);

    @NotNull
    default public Stream<BlockGraph> getAllGraphsInChunkSection(@NotNull class_4076 pos) {
        return this.getAllGraphIdsInChunkSection(pos).mapToObj(this::getGraph).filter(Objects::nonNull);
    }

    @NotNull
    public Stream<BlockGraph> getLoadedGraphsInChunkSection(@NotNull class_4076 var1);

    @NotNull
    public LongStream getAllGraphIdsInChunk(@NotNull class_1923 var1);

    @NotNull
    default public Stream<BlockGraph> getAllGraphsInChunk(@NotNull class_1923 pos) {
        return this.getAllGraphIdsInChunk(pos).mapToObj(this::getGraph).filter(Objects::nonNull);
    }

    @NotNull
    public Stream<BlockGraph> getLoadedGraphsInChunk(@NotNull class_1923 var1);

    @NotNull
    public LongStream getAllGraphIds();

    @NotNull
    default public Stream<BlockGraph> getAllGraphs() {
        return this.getAllGraphIds().mapToObj(this::getGraph).filter(Objects::nonNull);
    }

    @NotNull
    public Stream<BlockGraph> getLoadedGraphs();
}

