/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.graphlib.api.graph;

import com.kneelawk.graphlib.api.graph.GraphView;
import com.kneelawk.graphlib.api.graph.GraphWorld;
import com.kneelawk.graphlib.api.graph.user.BlockNodeDiscoverer;
import com.kneelawk.graphlib.api.graph.user.BlockNodeType;
import com.kneelawk.graphlib.api.graph.user.GraphEntityType;
import com.kneelawk.graphlib.api.graph.user.LinkEntityType;
import com.kneelawk.graphlib.api.graph.user.LinkKeyType;
import com.kneelawk.graphlib.api.graph.user.NodeEntityType;
import com.kneelawk.graphlib.api.graph.user.SyncProfile;
import com.kneelawk.graphlib.api.util.CacheCategory;
import com.kneelawk.graphlib.api.world.SaveMode;
import com.kneelawk.graphlib.impl.graph.simple.SimpleGraphUniverseBuilder;
import java.util.Collection;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface GraphUniverse {
    @Deprecated
    @NotNull
    public GraphView getGraphView(@NotNull class_1937 var1);

    @Nullable
    public GraphView getSidedGraphView(@NotNull class_1937 var1);

    @NotNull
    public GraphWorld getServerGraphWorld(@NotNull class_3218 var1);

    @Nullable
    public GraphView getClientGraphView();

    @NotNull
    public class_2960 getId();

    @NotNull
    public SaveMode getSaveMode();

    public void addDiscoverer(@NotNull BlockNodeDiscoverer var1);

    public void addDiscoverers(BlockNodeDiscoverer ... var1);

    public void addDiscoverers(@NotNull Iterable<BlockNodeDiscoverer> var1);

    public void addDiscoverers(@NotNull Collection<BlockNodeDiscoverer> var1);

    public void addNodeType(@NotNull BlockNodeType var1);

    default public void addNodeTypes(BlockNodeType ... types) {
        for (BlockNodeType type : types) {
            this.addNodeType(type);
        }
    }

    default public void addNodeTypes(@NotNull Iterable<BlockNodeType> types) {
        for (BlockNodeType type : types) {
            this.addNodeType(type);
        }
    }

    @Nullable
    public BlockNodeType getNodeType(@NotNull class_2960 var1);

    public void addNodeEntityType(@NotNull NodeEntityType var1);

    default public void addNodeEntityTypes(NodeEntityType ... types) {
        for (NodeEntityType type : types) {
            this.addNodeEntityType(type);
        }
    }

    default public void addNodeEntityTypes(@NotNull Iterable<NodeEntityType> types) {
        for (NodeEntityType type : types) {
            this.addNodeEntityType(type);
        }
    }

    @Nullable
    public NodeEntityType getNodeEntityType(@NotNull class_2960 var1);

    public void addLinkKeyType(@NotNull LinkKeyType var1);

    default public void addLinkKeyTypes(LinkKeyType ... types) {
        for (LinkKeyType type : types) {
            this.addLinkKeyType(type);
        }
    }

    default public void addLinkKeyTypes(@NotNull Iterable<LinkKeyType> types) {
        for (LinkKeyType type : types) {
            this.addLinkKeyType(type);
        }
    }

    @Nullable
    public LinkKeyType getLinkKeyType(@NotNull class_2960 var1);

    public void addLinkEntityType(@NotNull LinkEntityType var1);

    default public void addLinkEntityTypes(LinkEntityType ... types) {
        for (LinkEntityType type : types) {
            this.addLinkEntityType(type);
        }
    }

    default public void addLinkEntityTypes(@NotNull Iterable<LinkEntityType> types) {
        for (LinkEntityType type : types) {
            this.addLinkEntityType(type);
        }
    }

    @Nullable
    public LinkEntityType getLinkEntityType(@NotNull class_2960 var1);

    public void addGraphEntityType(@NotNull GraphEntityType<?> var1);

    default public void addGraphEntityTypes(GraphEntityType<?> ... types) {
        for (GraphEntityType<?> type : types) {
            this.addGraphEntityType(type);
        }
    }

    default public void addGraphEntityTypes(@NotNull Iterable<GraphEntityType<?>> types) {
        for (GraphEntityType<?> type : types) {
            this.addGraphEntityType(type);
        }
    }

    @Nullable
    public GraphEntityType<?> getGraphEntityType(@NotNull class_2960 var1);

    @NotNull
    public Iterable<GraphEntityType<?>> getAllGraphEntityTypes();

    public void addCacheCategory(@NotNull CacheCategory<?> var1);

    default public void addCacheCategories(CacheCategory<?> ... categories) {
        for (CacheCategory<?> category : categories) {
            this.addCacheCategory(category);
        }
    }

    default public void addCacheCategories(@NotNull Iterable<CacheCategory<?>> categories) {
        for (CacheCategory<?> category : categories) {
            this.addCacheCategory(category);
        }
    }

    @NotNull
    public Iterable<CacheCategory<?>> getCacheCatetories();

    public void register();

    public int getDefaultDebugColor(@NotNull class_2960 var1);

    @NotNull
    public SyncProfile getSyncProfile();

    @Contract(value="-> new", pure=true)
    @NotNull
    public static Builder builder() {
        return new SimpleGraphUniverseBuilder();
    }

    public static interface Builder {
        @NotNull
        public GraphUniverse build(@NotNull class_2960 var1);

        @NotNull
        public Builder saveMode(@NotNull SaveMode var1);

        @NotNull
        public Builder synchronizeToClient(@NotNull SyncProfile var1);
    }
}

