/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.graphlib.api.event;

import com.kneelawk.graphlib.api.graph.BlockGraph;
import com.kneelawk.graphlib.api.graph.GraphWorld;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_3218;

public final class GraphLibEvents {
    public static final Event<GraphCreatedListener> GRAPH_CREATED = EventFactory.createArrayBacked(GraphCreatedListener.class, (world, controller, graph) -> {}, listeners -> (world, graphWorld, graph) -> {
        for (GraphCreatedListener listener : listeners) {
            listener.graphCreated(world, graphWorld, graph);
        }
    });
    public static final Event<GraphUpdatedListener> GRAPH_UPDATED = EventFactory.createArrayBacked(GraphUpdatedListener.class, (world, controller, graph) -> {}, listeners -> (world, graphWorld, graph) -> {
        for (GraphUpdatedListener listener : listeners) {
            listener.graphUpdated(world, graphWorld, graph);
        }
    });
    public static final Event<GraphUnloadingListener> GRAPH_UNLOADING = EventFactory.createArrayBacked(GraphUnloadingListener.class, (world, graphWorld, graph) -> {}, listeners -> (world, graphWorld, graph) -> {
        for (GraphUnloadingListener listener : listeners) {
            listener.graphUnloading(world, graphWorld, graph);
        }
    });
    public static final Event<GraphDestroyedListener> GRAPH_DESTROYED = EventFactory.createArrayBacked(GraphDestroyedListener.class, (world, controller, id) -> {}, listeners -> (world, graphWorld, id) -> {
        for (GraphDestroyedListener listener : listeners) {
            listener.graphDestroyed(world, graphWorld, id);
        }
    });

    private GraphLibEvents() {
    }

    public static interface GraphDestroyedListener {
        public void graphDestroyed(class_3218 var1, GraphWorld var2, long var3);
    }

    public static interface GraphUnloadingListener {
        public void graphUnloading(class_3218 var1, GraphWorld var2, BlockGraph var3);
    }

    public static interface GraphUpdatedListener {
        public void graphUpdated(class_3218 var1, GraphWorld var2, BlockGraph var3);
    }

    public static interface GraphCreatedListener {
        public void graphCreated(class_3218 var1, GraphWorld var2, BlockGraph var3);
    }
}

