/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.graphlib.api.client.render;

import com.google.common.math.IntMath;
import com.kneelawk.graphlib.api.util.ColorUtils;
import java.math.RoundingMode;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector4f;

@Environment(value=EnvType.CLIENT)
public final class RenderUtils {
    private static final class_243[][] PLANAR_VECTORS = new class_243[][]{{new class_243(1.0, 0.0, 0.0), new class_243(0.0, 0.0, 1.0)}, {new class_243(1.0, 0.0, 0.0), new class_243(0.0, 1.0, 0.0)}, {new class_243(0.0, 0.0, 1.0), new class_243(0.0, 1.0, 0.0)}};

    private RenderUtils() {
    }

    public static void drawCube(@NotNull class_4587 stack, @NotNull class_4588 consumer, float x, float y, float z, float width, float height, float depth, int color) {
        RenderUtils.drawCube(stack, consumer, x, y, z, width, 0.0f, 0.0f, 0.0f, height, 0.0f, 0.0f, 0.0f, depth, color);
    }

    public static void drawCube(@NotNull class_4587 stack, @NotNull class_4588 consumer, float x, float y, float z, float radX0, float radY0, float radZ0, float radX1, float radY1, float radZ1, float radX2, float radY2, float radZ2, int color) {
        RenderUtils.drawRect(stack, consumer, x - radX2, y - radY2, z - radZ2, radX0, radY0, radZ0, radX1, radY1, radZ1, color);
        RenderUtils.drawRect(stack, consumer, x + radX2, y + radY2, z + radZ2, radX0, radY0, radZ0, radX1, radY1, radZ1, color);
        RenderUtils.drawLine(stack, consumer, x - radX0 - radX1 - radX2, y - radY0 - radY1 - radY2, z - radZ0 - radZ1 - radZ2, x - radX0 - radX1 + radX2, y - radY0 - radY1 + radY2, z - radZ0 - radZ1 + radZ2, color);
        RenderUtils.drawLine(stack, consumer, x - radX0 + radX1 - radX2, y - radY0 + radY1 - radY2, z - radZ0 + radZ1 - radZ2, x - radX0 + radX1 + radX2, y - radY0 + radY1 + radY2, z - radZ0 + radZ1 + radZ2, color);
        RenderUtils.drawLine(stack, consumer, x + radX0 + radX1 - radX2, y + radY0 + radY1 - radY2, z + radZ0 + radZ1 - radZ2, x + radX0 + radX1 + radX2, y + radY0 + radY1 + radY2, z + radZ0 + radZ1 + radZ2, color);
        RenderUtils.drawLine(stack, consumer, x + radX0 - radX1 - radX2, y + radY0 - radY1 - radY2, z + radZ0 - radZ1 - radZ2, x + radX0 - radX1 + radX2, y + radY0 - radY1 + radY2, z + radZ0 - radZ1 + radZ2, color);
    }

    public static void drawRect(@NotNull class_4587 stack, @NotNull class_4588 consumer, float x, float y, float z, float radX, float radY, class_2350 normal, int color) {
        class_243[] vecs = PLANAR_VECTORS[normal.ordinal() >> 1];
        RenderUtils.drawRect(stack, consumer, x, y, z, (float)vecs[0].field_1352 * radX, (float)vecs[0].field_1351 * radX, (float)vecs[0].field_1350 * radX, (float)vecs[1].field_1352 * radY, (float)vecs[1].field_1351 * radY, (float)vecs[1].field_1350 * radY, color);
    }

    public static void drawRect(@NotNull class_4587 stack, @NotNull class_4588 consumer, float x, float y, float z, float radX0, float radY0, float radZ0, float radX1, float radY1, float radZ1, int color) {
        RenderUtils.drawLine(stack, consumer, x - radX0 - radX1, y - radY0 - radY1, z - radZ0 - radZ1, x - radX0 + radX1, y - radY0 + radY1, z - radZ0 + radZ1, color);
        RenderUtils.drawLine(stack, consumer, x - radX0 + radX1, y - radY0 + radY1, z - radZ0 + radZ1, x + radX0 + radX1, y + radY0 + radY1, z + radZ0 + radZ1, color);
        RenderUtils.drawLine(stack, consumer, x + radX0 + radX1, y + radY0 + radY1, z + radZ0 + radZ1, x + radX0 - radX1, y + radY0 - radY1, z + radZ0 - radZ1, color);
        RenderUtils.drawLine(stack, consumer, x + radX0 - radX1, y + radY0 - radY1, z + radZ0 - radZ1, x - radX0 - radX1, y - radY0 - radY1, z - radZ0 - radZ1, color);
    }

    public static void drawLine(@NotNull class_4587 stack, @NotNull class_4588 consumer, float x0, float y0, float z0, float x1, float y1, float z1, int color) {
        Matrix4f model = stack.method_23760().method_23761();
        Matrix3f normal = stack.method_23760().method_23762();
        float dx = x1 - x0;
        float dy = y1 - y0;
        float dz = z1 - z0;
        float fact = class_3532.method_48119((float)(dx * dx + dy * dy + dz * dz));
        Vector4f pos = model.transform(new Vector4f(x0, y0, z0, 1.0f));
        Vector3f norm = normal.transform(new Vector3f(dx *= fact, dy *= fact, dz *= fact));
        consumer.method_22912((double)pos.x, (double)pos.y, (double)pos.z).method_39415(color).method_22914(norm.x, norm.y, norm.z).method_1344();
        model.transform(pos.set(x1, y1, z1, 1.0f));
        consumer.method_22912((double)pos.x, (double)pos.y, (double)pos.z).method_39415(color).method_22914(norm.x, norm.y, norm.z).method_1344();
    }

    public static void fillCube(@NotNull class_4587 stack, @NotNull class_4588 consumer, float x, float y, float z, float width, float height, float depth, int color) {
        RenderUtils.fillCube(stack, consumer, x, y, z, width, 0.0f, 0.0f, 0.0f, height, 0.0f, 0.0f, 0.0f, depth, color);
    }

    public static void fillCube(@NotNull class_4587 stack, @NotNull class_4588 consumer, float x, float y, float z, float radX0, float radY0, float radZ0, float radX1, float radY1, float radZ1, float radX2, float radY2, float radZ2, int color) {
        RenderUtils.fillRect(stack, consumer, x - radX1, y - radY1, z - radZ1, radX0, radY0, radZ0, radX2, radY2, radZ2, color);
        RenderUtils.fillRect(stack, consumer, x + radX1, y + radY1, z + radZ1, radX0, radY0, radZ0, -radX2, -radY2, -radZ2, color);
        RenderUtils.fillRect(stack, consumer, x - radX2, y - radY2, z - radZ2, -radX0, -radY0, -radZ0, radX1, radY1, radZ1, color);
        RenderUtils.fillRect(stack, consumer, x + radX2, y + radY2, z + radZ2, radX0, radY0, radZ0, radX1, radY1, radZ1, color);
        RenderUtils.fillRect(stack, consumer, x - radX0, y - radY0, z - radZ0, radX2, radY2, radZ2, radX1, radY1, radZ1, color);
        RenderUtils.fillRect(stack, consumer, x + radX0, y + radY0, z + radZ0, -radX2, -radY2, -radZ2, radX1, radY1, radZ1, color);
    }

    public static void fillRect(@NotNull class_4587 stack, @NotNull class_4588 consumer, float x, float y, float z, float radX, float radY, class_2350 normal, int color) {
        class_243[] vecs = PLANAR_VECTORS[normal.ordinal() >> 1];
        RenderUtils.fillRect(stack, consumer, x, y, z, (float)vecs[0].field_1352 * radX, (float)vecs[0].field_1351 * radX, (float)vecs[0].field_1350 * radX, (float)vecs[1].field_1352 * radY, (float)vecs[1].field_1351 * radY, (float)vecs[1].field_1350 * radY, color);
    }

    public static void fillRect(@NotNull class_4587 stack, @NotNull class_4588 consumer, float x, float y, float z, float radX0, float radY0, float radZ0, float radX1, float radY1, float radZ1, int color) {
        Matrix4f model = stack.method_23760().method_23761();
        Vector4f pos = model.transform(new Vector4f(x - radX0 + radX1, y - radY0 + radY1, z - radZ0 + radZ1, 1.0f));
        consumer.method_22912((double)pos.x, (double)pos.y, (double)pos.z).method_39415(color).method_1344();
        model.transform(pos.set(x - radX0 - radX1, y - radY0 - radY1, z - radZ0 - radZ1, 1.0f));
        consumer.method_22912((double)pos.x, (double)pos.y, (double)pos.z).method_39415(color).method_1344();
        model.transform(pos.set(x + radX0 - radX1, y + radY0 - radY1, z + radZ0 - radZ1, 1.0f));
        consumer.method_22912((double)pos.x, (double)pos.y, (double)pos.z).method_39415(color).method_1344();
        model.transform(pos.set(x + radX0 + radX1, y + radY0 + radY1, z + radZ0 + radZ1, 1.0f));
        consumer.method_22912((double)pos.x, (double)pos.y, (double)pos.z).method_39415(color).method_1344();
    }

    public static int graphColor(long graphId) {
        return ColorUtils.hsba2Argb((float)graphId * 1.5707964f / 10.0f, 1.0f, 1.0f, 1.0f);
    }

    public static class_243 distributedEndpoint(int nodesAtPos, int indexAmongNodes, class_2350 side, double verticalOffset, double spacing, double verticalSpacing) {
        class_243[] spacings = PLANAR_VECTORS[side.ordinal() >> 1];
        return RenderUtils.distributedEndpoint(nodesAtPos, indexAmongNodes, 0.5 + (double)side.method_10148() * (0.5 - verticalOffset), 0.5 + (double)side.method_10164() * (0.5 - verticalOffset), 0.5 + (double)side.method_10165() * (0.5 - verticalOffset), spacings[0].field_1352 * spacing, spacings[0].field_1351 * spacing, spacings[0].field_1350 * spacing, spacings[1].field_1352 * spacing, spacings[1].field_1351 * spacing, spacings[1].field_1350 * spacing, (double)(-side.method_10148()) * verticalSpacing, (double)(-side.method_10164()) * verticalSpacing, (double)(-side.method_10165()) * verticalSpacing);
    }

    public static class_243 distributedEndpoint(int nodesAtPos, int indexAmongNodes, double spacing, double verticalSpacing) {
        return RenderUtils.distributedEndpoint(nodesAtPos, indexAmongNodes, 0.5, 0.5, 0.5, spacing, 0.0, 0.0, 0.0, 0.0, spacing, 0.0, verticalSpacing, 0.0);
    }

    public static class_243 distributedEndpoint(int nodesAtPos, int indexAmongNodes, double centerX, double centerY, double centerZ, double spaceX0, double spaceY0, double spaceZ0, double spaceX1, double spaceY1, double spaceZ1, double offsetX, double offsetY, double offsetZ) {
        if (nodesAtPos < 2) {
            return new class_243(centerX, centerY, centerZ);
        }
        int width = IntMath.sqrt((int)nodesAtPos, (RoundingMode)RoundingMode.CEILING);
        int indexX = indexAmongNodes % width;
        int indexY = indexAmongNodes / width;
        double posX = (double)indexX - (double)(width - 1) / 2.0;
        double posY = (double)indexY - (double)(width - 1) / 2.0;
        double posZ = (double)indexX + (double)indexY - (double)(width - 1);
        return new class_243(centerX + posX * spaceX0 + posY * spaceX1 + posZ * offsetX, centerY + posX * spaceY0 + posY * spaceY1 + posZ * offsetY, centerZ + posX * spaceZ0 + posY * spaceZ1 + posZ * offsetZ);
    }
}

