/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.coprocess;

import io.gitlab.jfronny.libjf.LibJf;
import io.gitlab.jfronny.libjf.coprocess.CoProcess;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;

public class CoProcessManager
implements ModInitializer {
    private final List<CoProcess> coProcesses = new ArrayList<CoProcess>();

    public void onInitialize() {
        this.coProcesses.addAll(FabricLoader.getInstance().getEntrypoints("libjf:coprocess", CoProcess.class));
        Runtime.getRuntime().addShutdownHook(new Thread(this::stop));
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
            ServerLifecycleEvents.SERVER_STOPPED.register(server -> this.stop());
        }
        this.start();
    }

    private void start() {
        for (CoProcess coProcess : this.coProcesses) {
            coProcess.start();
        }
    }

    private void stop() {
        Iterator<CoProcess> procs = this.coProcesses.iterator();
        while (procs.hasNext()) {
            CoProcess coProcess = procs.next();
            coProcess.stop();
            if (coProcess instanceof Closeable) {
                Closeable cl = (Closeable)((Object)coProcess);
                try {
                    cl.close();
                }
                catch (IOException e) {
                    LibJf.LOGGER.error("Could not close co-process", e);
                }
            }
            procs.remove();
        }
    }
}

