/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.BiFunction;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.CustomValue;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class Flags {
    public static Set<StringFlag> getStringFlags(String name) {
        return Flags.getFlags(name, (source, value) -> new StringFlag((String)source, (String)value), (source, value) -> new StringFlag((String)source, value.getAsString()));
    }

    public static Set<BooleanFlag> getBoolFlags(String name) {
        return Flags.getFlags(name, (source, value) -> new BooleanFlag((String)source, true), (source, value) -> new BooleanFlag((String)source, value.getAsBoolean()));
    }

    private static <T> Set<T> getFlags(String name, BiFunction<String, String, T> makeFromProp, BiFunction<String, CustomValue, T> makeFromFmj) {
        LinkedHashSet<T> flags = new LinkedHashSet<T>();
        String propName = "libjf." + name;
        if (System.getProperty(propName) != null) {
            flags.add(makeFromProp.apply("System Property", System.getProperty(propName)));
        }
        for (ModContainer mod : FabricLoader.getInstance().getAllMods()) {
            CustomValue.CvObject co;
            if (!mod.getMetadata().containsCustomValue("libjf") || !(co = mod.getMetadata().getCustomValue("libjf").getAsObject()).containsKey(name)) continue;
            flags.add(makeFromFmj.apply("Mod: " + mod.getMetadata().getId(), co.get(name)));
        }
        return flags;
    }

    public record BooleanFlag(String source, boolean value) {
    }

    public record StringFlag(String source, String value) {
    }
}

