/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.gson;

import java.util.Objects;

public class FormattingStyle {
    private final String newline;
    private final String indent;
    public static final FormattingStyle DEFAULT = new FormattingStyle("\n", "  ");

    private FormattingStyle(String newline, String indent) {
        Objects.requireNonNull(newline, "newline == null");
        Objects.requireNonNull(indent, "indent == null");
        if (!newline.matches("[\r\n]*")) {
            throw new IllegalArgumentException("Only combinations of \\n and \\r are allowed in newline.");
        }
        if (!indent.matches("[ \t]*")) {
            throw new IllegalArgumentException("Only combinations of spaces and tabs allowed in indent.");
        }
        this.newline = newline;
        this.indent = indent;
    }

    public FormattingStyle withNewline(String newline) {
        return new FormattingStyle(newline, this.indent);
    }

    public FormattingStyle withIndent(String indent) {
        return new FormattingStyle(this.newline, indent);
    }

    public String getNewline() {
        return this.newline;
    }

    public String getIndent() {
        return this.indent;
    }
}

