/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.tuple;

import io.gitlab.jfronny.commons.tuple.Quadruple;
import io.gitlab.jfronny.commons.tuple.Single;
import io.gitlab.jfronny.commons.tuple.Triple;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record Tuple<T1, T2>(@Nullable T1 left, @Nullable T2 right) {
    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <T1> Single<T1> of(@Nullable T1 val) {
        return new Single<T1>(val);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static <T1, T2> Tuple<T1, T2> of(@Nullable T1 left, @Nullable T2 right) {
        return new Tuple<T1, T2>(left, right);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static <T1, T2, T3> Triple<T1, T2, T3> of(@Nullable T1 val1, @Nullable T2 val2, @Nullable T3 val3) {
        return new Triple<T1, T2, T3>(val1, val2, val3);
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    @NotNull
    public static <T1, T2, T3, T4> Quadruple<T1, T2, T3, T4> of(@Nullable T1 val1, @Nullable T2 val2, @Nullable T3 val3, @Nullable T4 val4) {
        return new Quadruple<T1, T2, T3, T4>(val1, val2, val3, val4);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <T1, T2> Tuple<T1, T2> from(@NotNull Map.Entry<T1, T2> entry) {
        Objects.requireNonNull(entry);
        return new Tuple<T1, T2>(entry.getKey(), entry.getValue());
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public <T> Tuple<T, T2> mapLeft(@NotNull Function<T1, T> mapper) {
        return new Tuple<T, T2>(Objects.requireNonNull(mapper).apply(this.left), this.right);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public <T> Tuple<T1, T> mapRight(@NotNull Function<T2, T> mapper) {
        return new Tuple<T1, T>(this.left, Objects.requireNonNull(mapper).apply(this.right));
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public Tuple<T2, T1> swap() {
        return new Tuple<T2, T1>(this.right, this.left);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <T1, T2> Set<Tuple<T1, T2>> from(final @NotNull Map<T1, T2> map) {
        Objects.requireNonNull(map);
        return new AbstractSet<Tuple<T1, T2>>(){

            @Override
            public int size() {
                return map.size();
            }

            @Override
            public boolean isEmpty() {
                return map.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                if (o instanceof Tuple) {
                    Tuple tup = (Tuple)o;
                    if (map.containsKey(tup.left) && map.get(tup.left) == tup.right) {
                        return true;
                    }
                }
                return map.containsKey(o);
            }

            @Override
            @NotNull
            public Iterator<Tuple<T1, T2>> iterator() {
                return map.entrySet().stream().map(Tuple::from).iterator();
            }

            @Override
            @NotNull
            public @NotNull Object @NotNull [] toArray() {
                return map.entrySet().stream().map(Tuple::from).toArray();
            }

            @Override
            public boolean add(Tuple<T1, T2> t1T2Tuple) {
                return map.put(t1T2Tuple.left, t1T2Tuple.right) == null;
            }

            @Override
            public boolean remove(Object o) {
                if (o instanceof Tuple) {
                    Tuple t = (Tuple)o;
                    return map.remove(t.left, t.right);
                }
                return map.remove(o) != null;
            }

            @Override
            public void clear() {
                map.clear();
            }
        };
    }
}

