/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.throwable;

import io.gitlab.jfronny.commons.throwable.ThrowingBooleanSupplier;
import io.gitlab.jfronny.commons.throwable.ThrowingFunction;
import io.gitlab.jfronny.commons.throwable.ThrowingSupplier;
import io.gitlab.jfronny.commons.throwable.Try;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface ThrowingPredicate<T, TEx extends Throwable> {
    public boolean test(T var1) throws TEx;

    @Contract(value="_ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public <V> ThrowingPredicate<V, TEx> compose(@NotNull ThrowingFunction<? super V, ? extends T, ? extends TEx> before) {
        Objects.requireNonNull(before);
        return t -> this.test(before.apply((Object)t));
    }

    @Contract(value="_ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public ThrowingBooleanSupplier<TEx> compose(@NotNull ThrowingSupplier<? extends T, ? extends TEx> before) {
        Objects.requireNonNull(before);
        return () -> this.test(before.get());
    }

    @Contract(value="_ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public ThrowingPredicate<T, TEx> and(@NotNull ThrowingPredicate<? super T, ? extends TEx> other) {
        Objects.requireNonNull(other);
        return t -> this.test(t) && other.test(t);
    }

    @Contract(value="_ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public ThrowingPredicate<T, TEx> and(@NotNull ThrowingBooleanSupplier<? extends TEx> other) {
        Objects.requireNonNull(other);
        return t -> this.test(t) && other.get();
    }

    @Contract(value="_ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public ThrowingPredicate<T, TEx> or(@NotNull ThrowingPredicate<? super T, ? extends TEx> other) {
        Objects.requireNonNull(other);
        return t -> this.test(t) || other.test(t);
    }

    @Contract(value="_ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public ThrowingPredicate<T, TEx> or(@NotNull ThrowingBooleanSupplier<? extends TEx> other) {
        Objects.requireNonNull(other);
        return t -> this.test(t) || other.get();
    }

    @Contract(value="_ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public ThrowingPredicate<T, TEx> xor(@NotNull ThrowingPredicate<? super T, ? extends TEx> other) {
        Objects.requireNonNull(other);
        return t -> this.test(t) ^ other.test(t);
    }

    @Contract(value="_ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public ThrowingPredicate<T, TEx> xor(@NotNull ThrowingBooleanSupplier<? extends TEx> other) {
        Objects.requireNonNull(other);
        return t -> this.test(t) ^ other.get();
    }

    @Contract(value="-> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public ThrowingPredicate<T, TEx> negate() {
        return t -> !this.test(t);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <T> ThrowingPredicate<T, Throwable> isEqual(@Nullable Object targetRef) {
        return null == targetRef ? Objects::isNull : targetRef::equals;
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <T, TEx extends Throwable> ThrowingPredicate<T, TEx> not(@NotNull ThrowingPredicate<T, TEx> target) {
        return Objects.requireNonNull(target).negate();
    }

    @Contract(value="_ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public Predicate<T> addHandler(@NotNull Predicate<Throwable> handler) {
        Objects.requireNonNull(handler);
        return r -> {
            try {
                return this.test(r);
            }
            catch (Throwable e) {
                return handler.test(e);
            }
        };
    }

    @Contract(value="_, _ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public Predicate<T> addHandler(@NotNull Class<TEx> exception, @NotNull Predicate<TEx> handler) {
        Objects.requireNonNull(exception);
        Objects.requireNonNull(handler);
        return r -> {
            try {
                return this.test(r);
            }
            catch (Throwable e) {
                if (exception.isAssignableFrom(e.getClass())) {
                    return handler.test(e);
                }
                throw Try.runtimeException(e);
            }
        };
    }

    @Contract(value="-> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public Predicate<T> orThrow() {
        return this.orThrow(Try::runtimeException)::test;
    }

    @Contract(value="_ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public <TEx1 extends Throwable> ThrowingPredicate<T, TEx1> orThrow(@NotNull Function<Throwable, TEx1> generator) {
        Objects.requireNonNull(generator);
        return r -> {
            try {
                return this.test(r);
            }
            catch (Throwable e) {
                throw (Throwable)generator.apply(e);
            }
        };
    }
}

