/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.serialize.gson.impl;

import io.gitlab.jfronny.commons.serialize.Serializer;
import io.gitlab.jfronny.commons.serialize.gson.api.v1.GsonHolder;
import io.gitlab.jfronny.gson.Gson;
import io.gitlab.jfronny.gson.JsonIOException;
import io.gitlab.jfronny.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;

public record GsonHolderSerializer(GsonHolder holder) implements Serializer
{
    @Override
    public String serialize(Object object) throws IOException {
        try {
            return this.getGson().toJson(object);
        }
        catch (JsonIOException | JsonSyntaxException e) {
            throw this.generateException(e);
        }
    }

    @Override
    public void serialize(Object object, Appendable writer) throws IOException {
        try {
            this.getGson().toJson(object, writer);
        }
        catch (Exception e) {
            throw this.generateException(e);
        }
    }

    @Override
    public <T> T deserialize(Reader source, Class<T> typeOfT) throws IOException {
        try {
            return this.getGson().fromJson(source, typeOfT);
        }
        catch (Exception e) {
            throw this.generateException(e);
        }
    }

    @Override
    public <T> T deserialize(Reader source, Type typeOfT) throws IOException {
        if (typeOfT instanceof Class) {
            Class k = (Class)typeOfT;
            return this.deserialize(source, k);
        }
        try {
            return this.getGson().fromJson(source, typeOfT);
        }
        catch (Exception e) {
            throw this.generateException(e);
        }
    }

    @Override
    public <T> T deserialize(String source, Class<T> typeOfT) throws IOException {
        try {
            return this.getGson().fromJson(source, typeOfT);
        }
        catch (Exception e) {
            throw this.generateException(e);
        }
    }

    @Override
    public <T> T deserialize(String source, Type typeOfT) throws IOException {
        if (typeOfT instanceof Class) {
            Class k = (Class)typeOfT;
            return this.deserialize(source, k);
        }
        try {
            return this.getGson().fromJson(source, typeOfT);
        }
        catch (Exception e) {
            throw this.generateException(e);
        }
    }

    private IOException generateException(Exception e) {
        boolean lackingMessage;
        if (e instanceof IOException) {
            IOException io = (IOException)e;
            return io;
        }
        Throwable cause = e.getCause();
        String message = e.getMessage();
        if (cause == null) {
            return new Serializer.SerializeException(message);
        }
        boolean bl = lackingMessage = message == null || message.equals(cause.toString());
        if (e instanceof JsonIOException) {
            if (lackingMessage) {
                if (cause instanceof IOException) {
                    IOException io = (IOException)cause;
                    return io;
                }
                return new Serializer.SerializeException(cause);
            }
            return new Serializer.SerializeException(message, cause);
        }
        if (lackingMessage) {
            return new Serializer.SerializeException(cause);
        }
        return new Serializer.SerializeException(message, cause);
    }

    private Gson getGson() {
        return this.holder.getGson();
    }

    @Override
    public String getFormatMime() {
        return "application/json";
    }
}

