/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.serialize.gson.api.v1;

import io.gitlab.jfronny.commons.ref.WeakSet;
import io.gitlab.jfronny.commons.serialize.Serializer;
import io.gitlab.jfronny.commons.serialize.gson.api.v1.GsonHolder;
import io.gitlab.jfronny.commons.serialize.gson.impl.GsonHolderSerializer;
import io.gitlab.jfronny.gson.GsonBuilder;
import io.gitlab.jfronny.gson.TypeAdapterFactory;
import java.lang.reflect.Type;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;

public class GsonHolders {
    @ApiStatus.Internal
    static final Set<Consumer<GsonBuilder>> KNOWN_MODIFICATIONS = new LinkedHashSet<Consumer<GsonBuilder>>();
    @ApiStatus.Internal
    static final WeakSet<GsonHolder> KNOWN_INSTANCES = new WeakSet();
    public static final GsonHolder API = new GsonHolder();
    public static final GsonHolder CONFIG = new GsonHolder().modifyBuilder(b -> b.setOmitQuotes().serializeSpecialFloatingPointValues().serializeNulls().setPrettyPrinting());

    public static void registerTypeAdapter(Type type, Object typeAdapter) {
        GsonHolders.modifyBuilder(b -> b.registerTypeAdapter(type, typeAdapter));
    }

    public static void registerTypeAdapterFactory(TypeAdapterFactory factory) {
        GsonHolders.modifyBuilder(b -> b.registerTypeAdapterFactory(factory));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void modifyBuilder(Consumer<GsonBuilder> func) {
        WeakSet<GsonHolder> weakSet = KNOWN_INSTANCES;
        synchronized (weakSet) {
            KNOWN_MODIFICATIONS.add(func);
            for (GsonHolder holder : KNOWN_INSTANCES) {
                holder.modifyBuilder(func);
            }
        }
    }

    public static void registerSerializer() {
        Serializer.setInstance(new GsonHolderSerializer(API));
    }
}

