/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.log;

import io.gitlab.jfronny.commons.log.Level;
import io.gitlab.jfronny.commons.log.Logger;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;

public class StdoutLogger
implements Logger {
    private final String name;
    private final boolean color;
    private final boolean thread;
    private final boolean timestamp;

    public StdoutLogger(String name) {
        this(name, false);
    }

    public StdoutLogger(String name, boolean color) {
        this(name, color, false, false);
    }

    public StdoutLogger(String name, boolean color, boolean thread, boolean timestamp) {
        this.name = name;
        this.color = color;
        this.thread = thread;
        this.timestamp = timestamp;
    }

    public static StdoutLogger fancy(String name) {
        return new StdoutLogger(name, true, true, true);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void trace(String msg) {
        System.out.println(this.generateMessage(msg, Level.TRACE));
    }

    @Override
    public void debug(String msg) {
        System.out.println(this.generateMessage(msg, Level.DEBUG));
    }

    @Override
    public void info(String msg) {
        System.out.println(this.generateMessage(msg, Level.INFO));
    }

    @Override
    public void warn(String msg) {
        System.out.println(this.generateMessage(msg, Level.WARN));
    }

    @Override
    public void error(String msg) {
        System.out.println(this.generateMessage(msg, Level.ERROR));
    }

    private String generateMessage(String msg, Level level) {
        StringBuilder sb = new StringBuilder();
        if (this.timestamp) {
            sb.append(DateTimeFormatter.ofPattern("HH:mm:ss.SSS").format(LocalTime.now())).append(' ');
        }
        if (this.thread) {
            String thread = Thread.currentThread().getName();
            if (this.color) {
                sb.append("\u001b[1;36m").append(thread).append("\u001b[0m").append(' ');
            } else {
                sb.append('{').append(thread).append("} ");
            }
        }
        if (this.color) {
            sb.append("\u001b[1;32m").append(this.name).append("\u001b[0m").append(' ');
        } else {
            sb.append('(').append(this.name).append(") ");
        }
        if (this.color) {
            sb.append(level.color).append(level.name()).append("\u001b[0m").append(' ');
        } else {
            sb.append(level.name().charAt(0)).append(' ');
        }
        sb.append(msg);
        return sb.toString();
    }
}

