/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.log;

import io.gitlab.jfronny.commons.log.DelegateLogger;
import io.gitlab.jfronny.commons.log.Level;
import io.gitlab.jfronny.commons.log.Logger;
import io.gitlab.jfronny.commons.log.StdoutLogger;
import io.gitlab.jfronny.commons.ref.WeakSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class HotSwappingDelegateLogger
extends DelegateLogger {
    public static Function<String, Logger> LOGGER_BUILDER;
    private static Level MINIMUM_LEVEL;
    private static final Set<HotSwappingDelegateLogger> KNOWN_LOGGERS;
    protected boolean minimumLevelChanged = false;
    private final String name;

    public static void resetStrategy() {
        LOGGER_BUILDER = StdoutLogger::fancy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateStrategy(@NotNull Function<String, Logger> factory) {
        LOGGER_BUILDER = Objects.requireNonNull(factory);
        Set<HotSwappingDelegateLogger> set = KNOWN_LOGGERS;
        synchronized (set) {
            for (HotSwappingDelegateLogger ref : KNOWN_LOGGERS) {
                ref.updateStrategy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateMinimumLevel(Level minimumLevel) {
        MINIMUM_LEVEL = Objects.requireNonNull(minimumLevel);
        Set<HotSwappingDelegateLogger> set = KNOWN_LOGGERS;
        synchronized (set) {
            for (HotSwappingDelegateLogger ref : KNOWN_LOGGERS) {
                ref.updateMinimumLevel();
            }
        }
    }

    public static HotSwappingDelegateLogger forName(@NotNull String name) {
        return new HotSwappingDelegateLogger(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HotSwappingDelegateLogger(String name) {
        this.name = name;
        Set<HotSwappingDelegateLogger> set = KNOWN_LOGGERS;
        synchronized (set) {
            this.updateStrategy();
            this.updateMinimumLevel();
            KNOWN_LOGGERS.add(this);
        }
    }

    private void updateStrategy() {
        this.delegate = LOGGER_BUILDER.apply(this.name);
    }

    private void updateMinimumLevel() {
        if (!this.minimumLevelChanged) {
            this.minimumLevel = MINIMUM_LEVEL;
        }
    }

    @Override
    public void setMinimumLevel(Level minLevel) {
        super.setMinimumLevel(minLevel);
        this.minimumLevelChanged = true;
    }

    static {
        MINIMUM_LEVEL = Level.INFO;
        KNOWN_LOGGERS = new WeakSet<HotSwappingDelegateLogger>();
        HotSwappingDelegateLogger.resetStrategy();
    }
}

