/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.log;

import io.gitlab.jfronny.commons.log.Logger;
import org.jetbrains.annotations.Nullable;

public class CompoundLogger
implements Logger {
    private final String name;
    private final Logger[] loggers;

    public CompoundLogger(String name, Logger ... loggers) {
        this.name = name;
        this.loggers = loggers;
    }

    @Override
    @Nullable
    public String getName() {
        return this.name;
    }

    @Override
    public void trace(String msg) {
        for (Logger logger : this.loggers) {
            logger.trace(msg);
        }
    }

    @Override
    public void trace(String format, Object arg) {
        for (Logger logger : this.loggers) {
            logger.trace(format, arg);
        }
    }

    @Override
    public void trace(String format, Object ... args) {
        for (Logger logger : this.loggers) {
            logger.trace(format, args);
        }
    }

    @Override
    public void trace(String msg, Throwable t) {
        for (Logger logger : this.loggers) {
            logger.trace(msg, t);
        }
    }

    @Override
    public void debug(String msg) {
        for (Logger logger : this.loggers) {
            logger.debug(msg);
        }
    }

    @Override
    public void debug(String format, Object arg) {
        for (Logger logger : this.loggers) {
            logger.debug(format, arg);
        }
    }

    @Override
    public void debug(String format, Object ... args) {
        for (Logger logger : this.loggers) {
            logger.debug(format, args);
        }
    }

    @Override
    public void debug(String msg, Throwable t) {
        for (Logger logger : this.loggers) {
            logger.debug(msg, t);
        }
    }

    @Override
    public void info(String msg) {
        for (Logger logger : this.loggers) {
            logger.info(msg);
        }
    }

    @Override
    public void info(String format, Object arg) {
        for (Logger logger : this.loggers) {
            logger.info(format, arg);
        }
    }

    @Override
    public void info(String format, Object ... args) {
        for (Logger logger : this.loggers) {
            logger.info(format, args);
        }
    }

    @Override
    public void info(String msg, Throwable t) {
        for (Logger logger : this.loggers) {
            logger.info(msg, t);
        }
    }

    @Override
    public void warn(String msg) {
        for (Logger logger : this.loggers) {
            logger.warn(msg);
        }
    }

    @Override
    public void warn(String format, Object arg) {
        for (Logger logger : this.loggers) {
            logger.warn(format, arg);
        }
    }

    @Override
    public void warn(String format, Object ... args) {
        for (Logger logger : this.loggers) {
            logger.warn(format, args);
        }
    }

    @Override
    public void warn(String msg, Throwable t) {
        for (Logger logger : this.loggers) {
            logger.warn(msg, t);
        }
    }

    @Override
    public void error(String msg) {
        for (Logger logger : this.loggers) {
            logger.error(msg);
        }
    }

    @Override
    public void error(String format, Object arg) {
        for (Logger logger : this.loggers) {
            logger.error(format, arg);
        }
    }

    @Override
    public void error(String format, Object ... args) {
        for (Logger logger : this.loggers) {
            logger.error(format, args);
        }
    }

    @Override
    public void error(String msg, Throwable t) {
        for (Logger logger : this.loggers) {
            logger.error(msg, t);
        }
    }

    @Override
    public String format(String format, Object arg) {
        if (this.loggers.length == 0) {
            return Logger.super.format(format, arg);
        }
        return this.loggers[0].format(format, arg);
    }

    @Override
    public String format(String format, Object ... args) {
        if (this.loggers.length == 0) {
            return Logger.super.format(format, args);
        }
        return this.loggers[0].format(format, args);
    }

    @Override
    public String format(String msg, Throwable t) {
        if (this.loggers.length == 0) {
            return Logger.super.format(msg, t);
        }
        return this.loggers[0].format(msg, t);
    }
}

