/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.data.impl.util;

import java.util.Map;
import java.util.Objects;

public final class KeyValuePair<K, V>
implements Map.Entry<K, V> {
    private final Map<K, V> source;
    private final K key;
    private V value;

    public KeyValuePair(K key, V value, Map<K, V> source) {
        this.key = key;
        this.value = value;
        this.source = source;
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public V setValue(V value) {
        V result = this.source.put(this.key, value);
        this.value = value;
        return result;
    }

    public String toString() {
        return "(" + this.key + ", " + this.value + ")";
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof KeyValuePair)) {
            return false;
        }
        KeyValuePair that = (KeyValuePair)obj;
        return Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.key, this.value);
    }
}

