/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.data.impl.node;

import io.gitlab.jfronny.commons.data.impl.node.Node;
import io.gitlab.jfronny.commons.data.impl.util.AtomicReferenceArrayListAdapter;
import io.gitlab.jfronny.commons.data.impl.util.NodeUtil;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReferenceArray;

public abstract class NonLeafNode<T>
extends Node<T> {
    private final AtomicReferenceArray<Node<T>> outgoingEdges;
    private final List<Node<T>> outgoingEdgesAsList;

    public NonLeafNode(CharSequence edgeCharSequence, List<Node<T>> outgoingEdges) {
        super(edgeCharSequence);
        Node[] childNodeArray = outgoingEdges.toArray(new Node[outgoingEdges.size()]);
        Arrays.sort(childNodeArray, null);
        this.outgoingEdges = new AtomicReferenceArray<Node>(childNodeArray);
        this.outgoingEdgesAsList = new AtomicReferenceArrayListAdapter<Node<Node<T>>>(this.outgoingEdges);
    }

    @Override
    public Node<T> getOutgoingEdge(Character edgeFirstCharacter) {
        int index = NodeUtil.binarySearchForEdge(this.outgoingEdges, edgeFirstCharacter);
        if (index < 0) {
            return null;
        }
        return this.outgoingEdges.get(index);
    }

    @Override
    public void updateOutgoingEdge(Node<T> childNode) {
        int index = NodeUtil.binarySearchForEdge(this.outgoingEdges, childNode.getIncomingEdgeFirstCharacter());
        if (index < 0) {
            throw new IllegalStateException("Cannot update the reference to the following child node for the edge starting with '" + childNode.getIncomingEdgeFirstCharacter() + "', no such edge already exists: " + childNode);
        }
        this.outgoingEdges.set(index, childNode);
    }

    @Override
    public List<Node<T>> getOutgoingEdges() {
        return this.outgoingEdgesAsList;
    }
}

