/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.data;

import io.gitlab.jfronny.commons.data.impl.node.Node;
import io.gitlab.jfronny.commons.data.impl.util.CharSequences;
import io.gitlab.jfronny.commons.data.impl.util.KeyValuePair;
import io.gitlab.jfronny.commons.data.impl.util.LazyIterator;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class String2ObjectMap<V>
extends AbstractMap<String, V>
implements Serializable,
Iterable<Map.Entry<String, V>> {
    protected volatile Node<V> root;
    private final Lock lock = new ReentrantLock();

    public String2ObjectMap() {
        this.root = Node.of("", Collections.emptyList(), true);
    }

    protected void acquireWriteLock() {
        this.lock.lock();
    }

    protected void releaseWriteLock() {
        this.lock.unlock();
    }

    @Override
    public V put(String key, V value) {
        return this.putInternal(key, value, true);
    }

    @Override
    @Nullable
    public V putIfAbsent(String key, V value) {
        return this.putInternal(key, value, false);
    }

    @Override
    public V get(Object key) {
        if (!(key instanceof CharSequence)) {
            return null;
        }
        CharSequence seq = (CharSequence)key;
        SearchResult<V> searchResult = this.searchTree(seq);
        if (searchResult.classification.equals((Object)SearchResult.Classification.EXACT_MATCH)) {
            return searchResult.nodeFound.hasValue() ? (V)searchResult.nodeFound.getValue() : null;
        }
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        if (!(key instanceof CharSequence)) {
            return false;
        }
        CharSequence seq = (CharSequence)key;
        SearchResult<V> searchResult = this.searchTree(seq);
        return searchResult.classification.equals((Object)SearchResult.Classification.EXACT_MATCH);
    }

    public Iterable<CharSequence> getKeysStartingWith(CharSequence prefix) {
        return this.getForKeysStartingWith(prefix, this::getDescendantKeys, Collections::emptySet);
    }

    public Iterable<V> getValuesForKeysStartingWith(CharSequence prefix) {
        return this.getForKeysStartingWith(prefix, this::getDescendantValues, Collections::emptySet);
    }

    public Iterable<? extends Map.Entry<String, V>> getKeyValuePairsForKeysStartingWith(CharSequence prefix) {
        return this.getForKeysStartingWith(prefix, this::getDescendantKeyValuePairs, Collections::emptySet);
    }

    private <T> T getForKeysStartingWith(CharSequence prefix, GetForKeysStartingWith<V, T> transform, Supplier<T> def) {
        SearchResult<V> searchResult = this.searchTree(prefix);
        SearchResult.Classification classification = searchResult.classification;
        switch (classification) {
            case EXACT_MATCH: {
                return transform.transform(prefix, searchResult.nodeFound);
            }
            case KEY_ENDS_MID_EDGE: {
                CharSequence edgeSuffix = CharSequences.getSuffix(searchResult.nodeFound.getIncomingEdge(), searchResult.charsMatchedInNodeFound);
                prefix = CharSequences.concatenate(prefix, edgeSuffix);
                return transform.transform(prefix, searchResult.nodeFound);
            }
        }
        return def.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        if (!(key instanceof CharSequence)) {
            throw new ClassCastException();
        }
        CharSequence csq = (CharSequence)key;
        this.acquireWriteLock();
        try {
            SearchResult<V> searchResult = this.searchTree(csq);
            SearchResult.Classification classification = searchResult.classification;
            if (Objects.requireNonNull(classification) != SearchResult.Classification.EXACT_MATCH) {
                V v = null;
                return v;
            }
            if (!searchResult.nodeFound.hasValue()) {
                V v = null;
                return v;
            }
            List childEdges = searchResult.nodeFound.getOutgoingEdges();
            if (childEdges.size() > 1) {
                Node cloned = searchResult.nodeFound.copyWithoutValue(false);
                searchResult.parentNode.updateOutgoingEdge(cloned);
            } else if (childEdges.size() == 1) {
                Node child = childEdges.get(0);
                CharSequence concatenatedEdges = CharSequences.concatenate(searchResult.nodeFound.getIncomingEdge(), child.getIncomingEdge());
                Node mergedNode = child.copyWithEdgeCharacters(concatenatedEdges, false);
                searchResult.parentNode.updateOutgoingEdge(mergedNode);
            } else {
                Node<Object> newParent;
                boolean parentIsRoot;
                List currentEdgesFromParent = searchResult.parentNode.getOutgoingEdges();
                List newEdgesOfParent = Arrays.asList(new Node[searchResult.parentNode.getOutgoingEdges().size() - 1]);
                int added = 0;
                int numParentEdges = currentEdgesFromParent.size();
                for (int i = 0; i < numParentEdges; ++i) {
                    Node node = currentEdgesFromParent.get(i);
                    if (node == searchResult.nodeFound) continue;
                    newEdgesOfParent.set(added++, node);
                }
                boolean bl = parentIsRoot = searchResult.parentNode == this.root;
                if (newEdgesOfParent.size() == 1 && !searchResult.parentNode.hasValue() && !parentIsRoot) {
                    Node parentsRemainingChild = newEdgesOfParent.get(0);
                    CharSequence concatenatedEdges = CharSequences.concatenate(searchResult.parentNode.getIncomingEdge(), parentsRemainingChild.getIncomingEdge());
                    newParent = parentsRemainingChild.copyWithEdgeCharacters(concatenatedEdges, false);
                } else {
                    newParent = searchResult.parentNode.copyWithChildren(newEdgesOfParent, parentIsRoot);
                }
                if (parentIsRoot) {
                    this.root = newParent;
                } else {
                    searchResult.parentNodesParent.updateOutgoingEdge(newParent);
                }
            }
            Object v = searchResult.nodeFound.getValue();
            return v;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public Iterable<CharSequence> getClosestKeys(CharSequence candidate) {
        return this.getForClosestKeys(candidate, this::getDescendantKeys);
    }

    public Iterable<V> getValuesForClosestKeys(CharSequence candidate) {
        return this.getForClosestKeys(candidate, this::getDescendantValues);
    }

    public Iterable<? extends Map.Entry<String, V>> getKeyValuePairsForClosestKeys(CharSequence candidate) {
        return this.getForClosestKeys(candidate, this::getDescendantKeyValuePairs);
    }

    private <T> Iterable<T> getForClosestKeys(CharSequence candidate, GetForClosestKeys<V, Iterable<T>> transform) {
        SearchResult<V> searchResult = this.searchTree(candidate);
        SearchResult.Classification classification = searchResult.classification;
        return switch (classification) {
            case SearchResult.Classification.EXACT_MATCH -> transform.transform(candidate, searchResult.nodeFound);
            case SearchResult.Classification.KEY_ENDS_MID_EDGE -> {
                CharSequence edgeSuffix = CharSequences.getSuffix(searchResult.nodeFound.getIncomingEdge(), searchResult.charsMatchedInNodeFound);
                candidate = CharSequences.concatenate(candidate, edgeSuffix);
                yield transform.transform(candidate, searchResult.nodeFound);
            }
            case SearchResult.Classification.INCOMPLETE_MATCH_TO_MIDDLE_OF_EDGE -> {
                CharSequence keyOfParentNode = CharSequences.getPrefix(candidate, searchResult.charsMatched - searchResult.charsMatchedInNodeFound);
                CharSequence keyOfNodeFound = CharSequences.concatenate(keyOfParentNode, searchResult.nodeFound.getIncomingEdge());
                yield transform.transform(keyOfNodeFound, searchResult.nodeFound);
            }
            case SearchResult.Classification.INCOMPLETE_MATCH_TO_END_OF_EDGE -> {
                if (searchResult.charsMatched == 0) {
                    yield Collections.emptySet();
                }
                CharSequence keyOfNodeFound = CharSequences.getPrefix(candidate, searchResult.charsMatched);
                yield transform.transform(keyOfNodeFound, searchResult.nodeFound);
            }
            default -> Collections.emptySet();
        };
    }

    @Override
    public int size() {
        LinkedList stack = new LinkedList();
        stack.push(this.root);
        int count = 0;
        while (!stack.isEmpty()) {
            Node current = (Node)stack.pop();
            stack.addAll(current.getOutgoingEdges());
            if (!current.hasValue()) continue;
            ++count;
        }
        return count;
    }

    V putInternal(CharSequence key, V value, boolean overwrite) {
        if (key == null) {
            throw new IllegalArgumentException("The key argument was null");
        }
        if (key.length() == 0) {
            throw new IllegalArgumentException("The key argument was zero-length");
        }
        if (value == null) {
            throw new IllegalArgumentException("The value argument was null");
        }
        this.acquireWriteLock();
        try {
            SearchResult<V> searchResult = this.searchTree(key);
            SearchResult.Classification classification = searchResult.classification;
            switch (classification) {
                case EXACT_MATCH: {
                    V existingValue;
                    V v = existingValue = searchResult.nodeFound.hasValue() ? (V)searchResult.nodeFound.getValue() : null;
                    if (!overwrite && searchResult.nodeFound.hasValue()) {
                        V v2 = existingValue;
                        return v2;
                    }
                    Node<V> replacementNode = Node.of(searchResult.nodeFound.getIncomingEdge(), value, searchResult.nodeFound.getOutgoingEdges(), false);
                    searchResult.parentNode.updateOutgoingEdge(replacementNode);
                    V v3 = existingValue;
                    return v3;
                }
                case KEY_ENDS_MID_EDGE: {
                    CharSequence keyCharsFromStartOfNodeFound = key.subSequence(searchResult.charsMatched - searchResult.charsMatchedInNodeFound, key.length());
                    CharSequence commonPrefix = CharSequences.getCommonPrefix(keyCharsFromStartOfNodeFound, searchResult.nodeFound.getIncomingEdge());
                    CharSequence suffixFromExistingEdge = CharSequences.subtractPrefix(searchResult.nodeFound.getIncomingEdge(), commonPrefix);
                    Node newChild = searchResult.nodeFound.copyWithEdgeCharacters(suffixFromExistingEdge, false);
                    Node<V> newParent = Node.of(commonPrefix, value, Arrays.asList(newChild), false);
                    searchResult.parentNode.updateOutgoingEdge(newParent);
                    V v = null;
                    return v;
                }
                case INCOMPLETE_MATCH_TO_END_OF_EDGE: {
                    CharSequence keySuffix = key.subSequence(searchResult.charsMatched, key.length());
                    Node<V> newChild = Node.of(keySuffix, value, Collections.emptyList(), false);
                    ArrayList edges = new ArrayList(searchResult.nodeFound.getOutgoingEdges().size() + 1);
                    edges.addAll(searchResult.nodeFound.getOutgoingEdges());
                    edges.add(newChild);
                    Node clonedNode = searchResult.nodeFound.copyWithChildren(edges, searchResult.nodeFound == this.root);
                    if (searchResult.nodeFound == this.root) {
                        this.root = clonedNode;
                    } else {
                        searchResult.parentNode.updateOutgoingEdge(clonedNode);
                    }
                    V newParent = null;
                    return newParent;
                }
                case INCOMPLETE_MATCH_TO_MIDDLE_OF_EDGE: {
                    CharSequence keyCharsFromStartOfNodeFound = key.subSequence(searchResult.charsMatched - searchResult.charsMatchedInNodeFound, key.length());
                    CharSequence commonPrefix = CharSequences.getCommonPrefix(keyCharsFromStartOfNodeFound, searchResult.nodeFound.getIncomingEdge());
                    CharSequence suffixFromExistingEdge = CharSequences.subtractPrefix(searchResult.nodeFound.getIncomingEdge(), commonPrefix);
                    CharSequence suffixFromKey = key.subSequence(searchResult.charsMatched, key.length());
                    Node<V> n1 = Node.of(suffixFromKey, value, Collections.emptyList(), false);
                    Node n2 = searchResult.nodeFound.copyWithEdgeCharacters(suffixFromExistingEdge, false);
                    Node n3 = Node.of(commonPrefix, Arrays.asList(n1, n2), false);
                    searchResult.parentNode.updateOutgoingEdge(n3);
                    V v = null;
                    return v;
                }
            }
            throw new IllegalStateException("Unexpected classification for search result: " + searchResult);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    Iterable<CharSequence> getDescendantKeys(CharSequence startKey, Node<V> startNode) {
        return this.getDescendantThing(startKey, startNode, (keyString, value) -> keyString);
    }

    Iterable<V> getDescendantValues(CharSequence startKey, Node<V> startNode) {
        return this.getDescendantThing(startKey, startNode, (keyString, value) -> value);
    }

    Iterable<KeyValuePair<String, V>> getDescendantKeyValuePairs(CharSequence startKey, Node<V> startNode) {
        return this.getDescendantThing(startKey, startNode, (keyString, value) -> new KeyValuePair<String, Object>(keyString, value, this));
    }

    private <T> Iterable<T> getDescendantThing(CharSequence startKey, Node<V> startNode, GetDescendantThing<V, T> transform) {
        return LazyIterator.iterable(() -> {
            Iterator descendantNodes = this.lazyTraverseDescendants(startKey, startNode).iterator();
            return scope -> {
                while (descendantNodes.hasNext()) {
                    NodeKeyPair nodeKeyPair = (NodeKeyPair)descendantNodes.next();
                    if (!nodeKeyPair.node.hasValue()) continue;
                    String keyString = String.valueOf(nodeKeyPair.key);
                    return transform.transform(keyString, nodeKeyPair.node.getValue());
                }
                return scope.endOfData();
            };
        });
    }

    protected Iterable<NodeKeyPair<V>> lazyTraverseDescendants(CharSequence startKey, Node<V> startNode) {
        return LazyIterator.iterable(() -> {
            LinkedList stack = new LinkedList();
            stack.push(new NodeKeyPair(startNode, startKey));
            return scope -> {
                if (stack.isEmpty()) {
                    return (NodeKeyPair)scope.endOfData();
                }
                NodeKeyPair current = (NodeKeyPair)stack.pop();
                List childNodes = current.node.getOutgoingEdges();
                for (int i = childNodes.size(); i > 0; --i) {
                    Node child = childNodes.get(i - 1);
                    stack.push(new NodeKeyPair(child, CharSequences.concatenate(current.key, child.getIncomingEdge())));
                }
                return current;
            };
        });
    }

    public SearchResult<V> searchTree(CharSequence key) {
        Node<V> nextNode;
        Node<V> parentNodesParent = null;
        Node<V> parentNode = null;
        Node<V> currentNode = this.root;
        int charsMatched = 0;
        int charsMatchedInNodeFound = 0;
        int keyLength = key.length();
        block0: while (charsMatched < keyLength && (nextNode = currentNode.getOutgoingEdge(Character.valueOf(key.charAt(charsMatched)))) != null) {
            parentNodesParent = parentNode;
            parentNode = currentNode;
            currentNode = nextNode;
            charsMatchedInNodeFound = 0;
            CharSequence currentNodeEdgeCharacters = currentNode.getIncomingEdge();
            int numEdgeChars = currentNodeEdgeCharacters.length();
            for (int i = 0; i < numEdgeChars && charsMatched < keyLength; ++i) {
                if (currentNodeEdgeCharacters.charAt(i) != key.charAt(charsMatched)) break block0;
                ++charsMatched;
                ++charsMatchedInNodeFound;
            }
        }
        return new SearchResult<V>(key, currentNode, charsMatched, charsMatchedInNodeFound, parentNode, parentNodesParent);
    }

    @Nullable
    public Map.Entry<String, V> searchTreeForLongestSubstring(CharSequence key) {
        Node<V> nextNode;
        String sKey = key.toString();
        Node<V> currentNode = this.root;
        KeyValuePair<String, V> lastWithValue = null;
        int charsMatched = 0;
        int keyLength = sKey.length();
        block0: while (charsMatched < keyLength && (nextNode = currentNode.getOutgoingEdge(Character.valueOf(sKey.charAt(charsMatched)))) != null) {
            currentNode = nextNode;
            int charsMatchedInNodeFound = 0;
            CharSequence currentNodeEdgeCharacters = currentNode.getIncomingEdge();
            int numEdgeChars = currentNodeEdgeCharacters.length();
            for (int j = 0; j < numEdgeChars && charsMatched < keyLength; ++j) {
                if (currentNodeEdgeCharacters.charAt(j) != sKey.charAt(charsMatched)) break block0;
                ++charsMatched;
                ++charsMatchedInNodeFound;
            }
            if (charsMatchedInNodeFound != currentNodeEdgeCharacters.length() || !currentNode.hasValue()) continue;
            lastWithValue = new KeyValuePair<String, V>(sKey.substring(0, charsMatched), currentNode.getValue(), this);
        }
        return lastWithValue;
    }

    @Override
    @NotNull
    public Set<Map.Entry<String, V>> entrySet() {
        return new AbstractSet<Map.Entry<String, V>>(){

            @Override
            public Iterator<Map.Entry<String, V>> iterator() {
                return String2ObjectMap.this.iterator();
            }

            @Override
            public int size() {
                return String2ObjectMap.this.size();
            }
        };
    }

    @Override
    public Iterator<Map.Entry<String, V>> iterator() {
        final Deque result = StreamSupport.stream(this.getDescendantKeyValuePairs("", this.root).spliterator(), false).collect(Collectors.toCollection(LinkedList::new));
        return new Iterator<Map.Entry<String, V>>(){
            Map.Entry<String, V> previous = null;

            @Override
            public boolean hasNext() {
                return !result.isEmpty();
            }

            @Override
            public Map.Entry<String, V> next() {
                if (result.isEmpty()) {
                    throw new NoSuchElementException();
                }
                this.previous = (Map.Entry)result.pop();
                return this.previous;
            }

            @Override
            public void remove() {
                if (this.previous == null) {
                    throw new IllegalStateException();
                }
                String2ObjectMap.this.remove(this.previous.getKey());
                this.previous = null;
            }
        };
    }

    public String prettyPrint() {
        return this.root.prettyPrint();
    }

    public UnaryOperator<String> asSubstitution() {
        return origin -> {
            StringBuilder result = new StringBuilder();
            int i = 0;
            while (i < origin.length()) {
                Map.Entry<String, V> lastWithValue = this.searchTreeForLongestSubstring(origin.substring(i));
                if (lastWithValue == null) {
                    result.append(origin.charAt(i));
                    ++i;
                    continue;
                }
                result.append(lastWithValue.getValue());
                i += lastWithValue.getKey().length();
            }
            return result.toString();
        };
    }

    public static class SearchResult<V> {
        final CharSequence key;
        final Node<V> nodeFound;
        final int charsMatched;
        final int charsMatchedInNodeFound;
        final Node<V> parentNode;
        final Node<V> parentNodesParent;
        final Classification classification;

        SearchResult(CharSequence key, Node<V> nodeFound, int charsMatched, int charsMatchedInNodeFound, Node<V> parentNode, Node<V> parentNodesParent) {
            this.key = key;
            this.nodeFound = nodeFound;
            this.charsMatched = charsMatched;
            this.charsMatchedInNodeFound = charsMatchedInNodeFound;
            this.parentNode = parentNode;
            this.parentNodesParent = parentNodesParent;
            this.classification = this.classify(key, nodeFound, charsMatched, charsMatchedInNodeFound);
        }

        protected Classification classify(CharSequence key, Node<V> nodeFound, int charsMatched, int charsMatchedInNodeFound) {
            if (charsMatched == key.length()) {
                if (charsMatchedInNodeFound == nodeFound.getIncomingEdge().length()) {
                    return Classification.EXACT_MATCH;
                }
                if (charsMatchedInNodeFound < nodeFound.getIncomingEdge().length()) {
                    return Classification.KEY_ENDS_MID_EDGE;
                }
            } else if (charsMatched < key.length()) {
                if (charsMatchedInNodeFound == nodeFound.getIncomingEdge().length()) {
                    return Classification.INCOMPLETE_MATCH_TO_END_OF_EDGE;
                }
                if (charsMatchedInNodeFound < nodeFound.getIncomingEdge().length()) {
                    return Classification.INCOMPLETE_MATCH_TO_MIDDLE_OF_EDGE;
                }
            }
            throw new IllegalStateException("Unexpected failure to classify SearchResult: " + this);
        }

        public String toString() {
            return "SearchResult{key=" + this.key + ", nodeFound=" + this.nodeFound + ", charsMatched=" + this.charsMatched + ", charsMatchedInNodeFound=" + this.charsMatchedInNodeFound + ", parentNode=" + this.parentNode + ", parentNodesParent=" + this.parentNodesParent + ", classification=" + this.classification + "}";
        }

        public static enum Classification {
            EXACT_MATCH,
            INCOMPLETE_MATCH_TO_END_OF_EDGE,
            INCOMPLETE_MATCH_TO_MIDDLE_OF_EDGE,
            KEY_ENDS_MID_EDGE;

        }
    }

    static interface GetForKeysStartingWith<V, T> {
        public T transform(CharSequence var1, Node<V> var2);
    }

    static interface GetForClosestKeys<V, T> {
        public T transform(CharSequence var1, Node<V> var2);
    }

    static interface GetDescendantThing<V, T> {
        public T transform(String var1, V var2);
    }

    protected static class NodeKeyPair<V> {
        public final Node<V> node;
        public final CharSequence key;

        public NodeKeyPair(Node<V> node, CharSequence key) {
            this.node = node;
            this.key = key;
        }
    }
}

