/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.cache;

import io.gitlab.jfronny.commons.io.JFiles;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;

public class FileBackedRef<T>
implements Closeable {
    private final Path filePath;
    private final Type type;
    private final WatchService service;
    private T cache = null;

    public FileBackedRef(Path filePath, Type type) throws IOException {
        this.filePath = filePath;
        this.type = type;
        this.service = FileSystems.getDefault().newWatchService();
        filePath.getParent().register(this.service, StandardWatchEventKinds.ENTRY_MODIFY);
    }

    public FileBackedRef(Path filePath, Class<T> type) throws IOException {
        this(filePath, (Type)type);
    }

    public T get() throws IOException {
        boolean update;
        WatchKey key = this.service.poll();
        boolean bl = update = this.cache == null;
        if (key != null) {
            for (WatchEvent<?> event : key.pollEvents()) {
                update |= event.context().equals(this.filePath);
            }
            key.reset();
        }
        if (update) {
            this.cache = JFiles.readObject(this.filePath, this.type);
        }
        return this.cache;
    }

    @Override
    public void close() throws IOException {
        this.service.close();
    }
}

