/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons;

import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;

public class StringFormatter {
    public static String toString(Object o) {
        if (o == null) {
            return "null";
        }
        if (o instanceof Double) {
            Double d = (Double)o;
            if (d % 1.0 == 0.0) {
                return String.format(Locale.US, "%.0f", d);
            }
            if (d > 1.0) {
                return String.format(Locale.US, "%.4f", d);
            }
            return String.format(Locale.US, "%s", d);
        }
        if (o instanceof Throwable) {
            Throwable t = (Throwable)o;
            return StringFormatter.toString(t, Objects::toString);
        }
        return o.toString();
    }

    public static String toString(Throwable t, Function<Throwable, String> stringify) {
        return stringify.apply(t) + "\n" + StringFormatter.getStackTrace(t, stringify);
    }

    public static String getStackTrace(Throwable t) {
        return StringFormatter.getStackTrace(t, Objects::toString);
    }

    public static String getStackTrace(Throwable t, Function<Throwable, String> stringify) {
        StringBuilder sb = new StringBuilder();
        StringFormatter.getStackTrace(sb, t, new StackTraceElement[0], "", "", Objects.requireNonNull(stringify), new HashSet<Throwable>(), true);
        return sb.toString();
    }

    private static void getStackTrace(StringBuilder sb, Throwable t, StackTraceElement[] enclosingTrace, String caption, String prefix, Function<Throwable, String> stringify, Set<Throwable> dejaVu, boolean skipHeader) {
        if (!skipHeader) {
            sb.append(prefix).append(caption);
        }
        if (!dejaVu.add(t)) {
            sb.append("[CIRCULAR REFERENCE: ").append(stringify.apply(t)).append("]\n");
            return;
        }
        StackTraceElement[] trace = t.getStackTrace();
        int m = trace.length - 1;
        for (int n = enclosingTrace.length - 1; m >= 0 && n >= 0 && trace[m].equals(enclosingTrace[n]); --m, --n) {
        }
        int framesInCommon = trace.length - 1 - m;
        if (!skipHeader) {
            sb.append(stringify.apply(t)).append('\n');
        }
        for (int i = 0; i <= m; ++i) {
            sb.append(prefix).append("\tat ").append(trace[i]).append('\n');
        }
        if (framesInCommon != 0) {
            sb.append(prefix).append("\t... ").append(framesInCommon).append(" more").append('\n');
        }
        for (Throwable se : t.getSuppressed()) {
            StringFormatter.getStackTrace(sb, se, trace, "Suppressed: ", prefix + "\t", stringify, dejaVu, false);
        }
        Throwable cause = t.getCause();
        if (cause != null) {
            StringFormatter.getStackTrace(sb, cause, trace, "Caused by: ", prefix, stringify, dejaVu, false);
        }
    }
}

