/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LazySupplier<T>
implements Supplier<T> {
    private final Supplier<T> supplier;
    private T cache = null;
    private boolean initialized;

    public LazySupplier(@Nullable T value) {
        this.supplier = () -> {
            throw new RuntimeException("Supplier should have never been called");
        };
        this.initialized = true;
        this.cache = value;
    }

    public LazySupplier(@NotNull Supplier<T> supplier) {
        this.supplier = Objects.requireNonNull(supplier);
        this.initialized = false;
    }

    @Override
    @NotNull
    public T get() {
        if (!this.initialized) {
            this.cache = this.supplier.get();
            this.initialized = true;
        }
        return this.cache;
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public LazySupplier<T> andThen(@NotNull Function<LazySupplier<T>, T> after) {
        return new LazySupplier<Object>(() -> after.apply(this));
    }
}

