/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons;

import io.gitlab.jfronny.commons.serialize.Serializer;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.InetSocketAddress;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class HttpUtils {
    private static String userAgent = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.36";
    private static final String PROXY_AUTH;
    private static final HttpClient CLIENT;

    public static void setUserAgent(String hostname) {
        if (hostname == null || hostname.isEmpty()) {
            throw new IllegalArgumentException("Hostname cannot be empty");
        }
        userAgent = hostname;
    }

    public static Request get(String url) throws URISyntaxException {
        return new Request(Method.GET, url);
    }

    public static Request post(String url) throws URISyntaxException {
        return new Request(Method.POST, url);
    }

    public static Request put(String url) throws URISyntaxException {
        return new Request(Method.PUT, url);
    }

    public static Request patch(String url) throws URISyntaxException {
        return new Request(Method.PATCH, url);
    }

    public static Request delete(String url) throws URISyntaxException {
        return new Request(Method.DELETE, url);
    }

    static {
        System.setProperty("jdk.http.auth.tunneling.disabledSchemes", "");
        HttpClient.Builder clientBuilder = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.ALWAYS);
        String host = System.getProperty("http.proxyHost");
        String port = System.getProperty("http.proxyPort");
        if (host != null && port != null) {
            if (port.matches("\\d+")) {
                clientBuilder.proxy(ProxySelector.of(new InetSocketAddress(host, Integer.parseInt(port))));
            } else {
                System.err.println("Could not parse proxy settings: Port is not a number");
            }
        }
        String name = System.getProperty("http.proxyUserName");
        String pass = System.getProperty("http.proxyUserPassword");
        PROXY_AUTH = name != null && pass != null ? "Basic " + new String(Base64.getEncoder().encode((name + ":" + pass).getBytes())) : null;
        CLIENT = clientBuilder.build();
    }

    public static class Request {
        private static final Predicate<String> CURSEFORGE_API = Pattern.compile("(?:http(s)?://)?addons-ecs\\.forgesvc\\.net/api/+").asMatchPredicate();
        private final String url;
        private final HttpRequest.Builder builder;
        private Method method;
        private int sent = 0;

        public Request(Method method, String url) throws URISyntaxException {
            this.url = url.replace(" ", "%20");
            this.builder = HttpRequest.newBuilder().uri(new URI(this.url));
            this.method = method;
            this.userAgent(userAgent);
        }

        public Request bearer(String token) {
            this.builder.header("Authorization", "Bearer " + token);
            return this;
        }

        public Request header(String name, String value) {
            this.builder.header(name, value);
            return this;
        }

        public Request setHeader(String name, String value) {
            this.builder.setHeader(name, value);
            return this;
        }

        public Request userAgent(String value) {
            return this.setHeader("User-Agent", value);
        }

        public Request bodyString(String string) {
            this.builder.header("Content-Type", "text/plain");
            this.builder.method(this.method.name(), HttpRequest.BodyPublishers.ofString(string));
            this.method = null;
            return this;
        }

        public Request bodyForm(String string) {
            this.builder.header("Content-Type", "application/x-www-form-urlencoded");
            this.builder.method(this.method.name(), HttpRequest.BodyPublishers.ofString(string));
            this.method = null;
            return this;
        }

        public Request bodyForm(Map<String, String> entries) {
            return this.bodyForm(entries.entrySet().stream().map(entry -> URLEncoder.encode((String)entry.getKey(), StandardCharsets.UTF_8) + "=" + URLEncoder.encode((String)entry.getValue(), StandardCharsets.UTF_8)).collect(Collectors.joining("&")));
        }

        public Request bodyJson(String string) {
            this.builder.header("Content-Type", "application/json");
            this.builder.method(this.method.name(), HttpRequest.BodyPublishers.ofString(string));
            this.method = null;
            return this;
        }

        public Request bodySerialized(Object object) throws IOException {
            Serializer serializer = Serializer.getInstance();
            this.builder.header("Content-Type", serializer.getFormatMime());
            this.builder.method(this.method.name(), HttpRequest.BodyPublishers.ofString(serializer.serialize(object)));
            this.method = null;
            return this;
        }

        private <T> T _send(String accept, HttpResponse.BodyHandler<T> responseBodyHandler) throws IOException {
            HttpResponse<T> res;
            ++this.sent;
            if (this.sent > 3) {
                throw new IOException("Attempted third redirect, stopping");
            }
            this.builder.header("Accept", accept);
            if (this.method != null) {
                this.builder.method(this.method.name(), HttpRequest.BodyPublishers.noBody());
            }
            if (PROXY_AUTH != null) {
                this.builder.header("Proxy-Authorization", PROXY_AUTH);
            }
            try {
                res = CLIENT.send(this.builder.build(), responseBodyHandler);
            }
            catch (InterruptedException e) {
                throw new IOException("Could not send request", e);
            }
            if (res.statusCode() / 100 == 2) {
                return res.body();
            }
            Optional<String> location = res.headers().firstValue("location");
            if (location.isPresent() && (res.statusCode() == 302 || res.statusCode() == 307) && this.method == Method.GET) {
                try {
                    return HttpUtils.get(location.get())._send(accept, responseBodyHandler);
                }
                catch (URISyntaxException e) {
                    throw new IOException("Could not follow redirect", e);
                }
            }
            if (CURSEFORGE_API.test(this.url) && res.statusCode() >= 500 && res.statusCode() < 600) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    throw new IOException("Could not sleep before resending request" + e);
                }
                return this._send(accept, responseBodyHandler);
            }
            if (res.statusCode() == 404) {
                throw new FileNotFoundException("Didn't find anything under that url (URL=" + this.url + ")");
            }
            throw new IOException("Unexpected return method: " + res.statusCode() + " (URL=" + this.url + ")");
        }

        public void send() throws IOException {
            this._send("*/*", HttpResponse.BodyHandlers.discarding());
        }

        public InputStream sendInputStream() throws IOException {
            return this._send("*/*", HttpResponse.BodyHandlers.ofInputStream());
        }

        public Reader sendReader() throws IOException {
            return new InputStreamReader(this.sendInputStream());
        }

        public String sendString() throws IOException {
            return this._send("*/*", HttpResponse.BodyHandlers.ofString());
        }

        public Stream<String> sendLines() throws IOException {
            return this._send("*/*", HttpResponse.BodyHandlers.ofLines());
        }

        public <T> T sendSerialized(Type type) throws IOException {
            Serializer serializer = Serializer.getInstance();
            InputStream in = this._send(serializer.getFormatMime(), HttpResponse.BodyHandlers.ofInputStream());
            try {
                return in == null ? null : (T)serializer.deserialize((Reader)new InputStreamReader(in), type);
            }
            catch (Serializer.SerializeException e) {
                throw new IOException("Could not deserialize", e);
            }
        }

        private String getString(Object a) throws IOException {
            if (a instanceof InputStream) {
                InputStream s = (InputStream)a;
                return new String(s.readAllBytes());
            }
            if (a instanceof String) {
                String s = (String)a;
                return s;
            }
            if (a instanceof Stream) {
                Stream s = (Stream)a;
                return s.collect(Collectors.joining());
            }
            return "";
        }
    }

    private static enum Method {
        GET,
        POST,
        PUT,
        PATCH,
        DELETE;

    }
}

