/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons;

import java.util.ArrayList;

public class ComparableVersion
implements Comparable<ComparableVersion> {
    private final String string;
    private final Long[] numbers;

    public ComparableVersion(String string) {
        this.string = string;
        String[] split = string.split("\\D+");
        ArrayList<Long> numbersList = new ArrayList<Long>();
        for (String s : split) {
            if (s.isEmpty()) continue;
            numbersList.add(Long.parseLong(s));
        }
        this.numbers = (Long[])numbersList.toArray(Long[]::new);
    }

    public String toString() {
        return this.string;
    }

    @Override
    public int compareTo(ComparableVersion version) {
        int maxLength = Math.max(this.numbers.length, version.numbers.length);
        for (int i = 0; i < maxLength; ++i) {
            long right;
            long left = i < this.numbers.length ? this.numbers[i] : 0L;
            long l = right = i < version.numbers.length ? version.numbers[i] : 0L;
            if (left == right) continue;
            return left < right ? -1 : 1;
        }
        return 0;
    }

    @Override
    public int compareTo(String version) {
        return this.compareTo(new ComparableVersion(version));
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public boolean equals(Object obj) {
        String str;
        ComparableVersion cv;
        return obj instanceof ComparableVersion && this.compareTo(cv = (ComparableVersion)obj) == 0 || obj instanceof String && this.compareTo(str = (String)obj) == 0;
    }
}

