/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.mixin.common;

import com.llamalad7.mixinextras.injector.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import io.github.fabricators_of_create.porting_lib.event.common.GrindstoneEvents;
import io.github.fabricators_of_create.porting_lib.extensions.extensions.GrindstoneMenuExtension;
import io.github.fabricators_of_create.porting_lib.util.PortingHooks;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3803;
import net.minecraft.class_3917;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3803.class})
public abstract class GrindstoneMenuMixin
extends class_1703
implements GrindstoneMenuExtension {
    @Shadow
    @Final
    public class_1263 field_16772;
    @Shadow
    @Final
    private class_1263 field_16773;
    @Unique
    private int xp = -1;

    protected GrindstoneMenuMixin(@Nullable class_3917<?> menuType, int i) {
        super(menuType, i);
    }

    @Inject(method={"createResult"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;isEmpty()Z", ordinal=3, shift=At.Shift.AFTER)}, cancellable=true)
    private void handleResult(CallbackInfo ci) {
        class_1799 top = this.field_16772.method_5438(0);
        class_1799 bottom = this.field_16772.method_5438(1);
        this.xp = PortingHooks.onGrindstoneChange(top, bottom, this.field_16773, -1);
        if (this.xp != Integer.MIN_VALUE) {
            ci.cancel();
            this.method_7623();
        }
    }

    public int getXp() {
        return this.xp;
    }

    @Mixin(targets={"net/minecraft/world/inventory/GrindstoneMenu$4"})
    public static abstract class GrindstoneMenuOutputSlotMixin {
        @Shadow(aliases={"field_16780"})
        @Final
        class_3803 menu;
        @Unique
        private GrindstoneEvents.OnTakeItem takeEvent;

        @WrapOperation(method={"method_17417"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/ExperienceOrb;award(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/phys/Vec3;I)V")})
        private void onGrindStoneTake(class_3218 level, class_243 pos, int amount, Operation<Void> original) {
            class_1263 input = this.menu.field_16772;
            class_1799 top = input.method_5438(0);
            class_1799 bottom = input.method_5438(1);
            this.takeEvent = new GrindstoneEvents.OnTakeItem(top, bottom, amount);
            this.takeEvent.sendEvent();
            if (!this.takeEvent.isCanceled()) {
                original.call(new Object[]{level, pos, this.takeEvent.getXp()});
            }
        }

        @ModifyArg(method={"onTake"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/Container;setItem(ILnet/minecraft/world/item/ItemStack;)V", ordinal=0), index=1)
        private class_1799 modifyTopSlotResult(class_1799 original) {
            class_1799 topItem;
            if (this.takeEvent != null && !(topItem = this.takeEvent.getNewTopItem()).method_7960()) {
                return topItem;
            }
            return original;
        }

        @ModifyArg(method={"onTake"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/Container;setItem(ILnet/minecraft/world/item/ItemStack;)V", ordinal=1), index=1)
        private class_1799 modifyBottomSlotResult(class_1799 original) {
            class_1799 bottomItem;
            if (this.takeEvent != null && !(bottomItem = this.takeEvent.getNewBottomItem()).method_7960()) {
                return bottomItem;
            }
            return original;
        }

        @WrapWithCondition(method={"onTake"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/Container;setItem(ILnet/minecraft/world/item/ItemStack;)V")})
        private boolean cancelInputRemoval(class_1263 container, int slot, class_1799 stack) {
            return this.takeEvent == null || !this.takeEvent.isCanceled();
        }

        @Inject(method={"onTake"}, at={@At(value="TAIL")})
        private void setChanged(class_1657 player, class_1799 itemStack, CallbackInfo ci) {
            this.menu.field_16772.method_5431();
        }

        @Inject(method={"getExperienceAmount"}, at={@At(value="HEAD")}, cancellable=true)
        private void customXp(class_1937 level, CallbackInfoReturnable<Integer> cir) {
            int exp = ((GrindstoneMenuExtension)this.menu).getXp();
            if (exp > -1) {
                cir.setReturnValue((Object)exp);
            }
        }
    }
}

