/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.translate.api;

import io.gitlab.jfronny.libjf.LibJf;
import io.gitlab.jfronny.libjf.translate.api.Language;
import io.gitlab.jfronny.libjf.translate.api.TranslateException;
import io.gitlab.jfronny.libjf.translate.impl.TranslateConfig;
import io.gitlab.jfronny.libjf.translate.impl.google.GoogleTranslateService;
import io.gitlab.jfronny.libjf.translate.impl.libretranslate.LibreTranslateService;
import io.gitlab.jfronny.libjf.translate.impl.noop.NoopTranslateService;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.LinkedList;
import java.util.List;

public interface TranslateService<T extends Language> {
    public static final List<String> INSTALLED_NAMES = List.of("Google", "LibreTranslate", "Noop");

    public static TranslateService<?> getConfigured() {
        return TranslateService.byName(TranslateConfig.translationService);
    }

    public static TranslateService<?> byName(String name) {
        return TranslateService.getAvailable().stream().filter(svc -> svc.getName().equals(name)).findFirst().orElseGet(() -> {
            String failure = INSTALLED_NAMES.contains(name) ? "configured" : " installed";
            LibJf.LOGGER.error("Falling back to NOOP translate service: " + name + " is not " + failure);
            return NoopTranslateService.INSTANCE;
        });
    }

    public static List<TranslateService<?>> getAvailable() {
        LinkedList result = new LinkedList();
        try {
            result.add(GoogleTranslateService.get());
        }
        catch (IOException | URISyntaxException e) {
            LibJf.LOGGER.error("Could not create Google Translate service", (Throwable)e);
        }
        try {
            result.add(LibreTranslateService.get(TranslateConfig.libreTranslateHost));
        }
        catch (TranslateException e) {
            LibJf.LOGGER.error("Could not create LibreTranslate service", (Throwable)e);
        }
        result.add(NoopTranslateService.INSTANCE);
        return List.copyOf(result);
    }

    public String translate(String var1, T var2, T var3) throws TranslateException;

    public T detect(String var1) throws TranslateException;

    public T parseLang(String var1);

    public List<T> getAvailableLanguages();

    public String getName();
}

