/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladiumcore.util.fabric;

import java.nio.file.Path;
import java.util.Collection;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_310;
import net.minecraft.server.MinecraftServer;
import net.threetag.palladiumcore.event.LifecycleEvents;
import net.threetag.palladiumcore.util.Platform;

public class PlatformImpl {
    public static MinecraftServer CACHED_SERVER = null;

    public static boolean isProduction() {
        return !FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    public static boolean isModLoaded(String id) {
        return FabricLoader.getInstance().isModLoaded(id);
    }

    public static Collection<String> getModIds() {
        return FabricLoader.getInstance().getAllMods().stream().map(ModContainer::getMetadata).map(ModMetadata::getId).toList();
    }

    public static boolean isClient() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT;
    }

    public static boolean isServer() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER;
    }

    public static boolean isForge() {
        return false;
    }

    public static boolean isFabric() {
        return true;
    }

    public static MinecraftServer getCurrentServer() {
        if (CACHED_SERVER != null) {
            return CACHED_SERVER;
        }
        if (PlatformImpl.isClient()) {
            return PlatformImpl.getFromClient();
        }
        return null;
    }

    @Environment(value=EnvType.CLIENT)
    private static MinecraftServer getFromClient() {
        return class_310.method_1551().method_1576();
    }

    public static void init() {
        LifecycleEvents.SERVER_ABOUT_TO_START.register(server -> {
            CACHED_SERVER = server;
        });
        LifecycleEvents.SERVER_STOPPED.register(server -> {
            CACHED_SERVER = null;
        });
    }

    public static Path getFolder() {
        return FabricLoader.getInstance().getGameDir().toAbsolutePath().normalize();
    }

    public static Platform.Mod getMod(String modId) {
        ModContainer mod = FabricLoader.getInstance().getModContainer(modId).orElse(null);
        if (mod != null) {
            return new Platform.Mod(mod.getMetadata().getId(), mod.getMetadata().getVersion().getFriendlyString(), mod.getMetadata().getName(), mod.getMetadata().getDescription());
        }
        return null;
    }
}

