/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladiumcore.util;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.nio.file.Path;
import java.util.Collection;
import net.minecraft.server.MinecraftServer;
import net.threetag.palladiumcore.util.fabric.PlatformImpl;
import org.jetbrains.annotations.Nullable;

public class Platform {
    private static byte ARCHITECTURY_LOADED = 0;

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isProduction() {
        return PlatformImpl.isProduction();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isModLoaded(String id) {
        return PlatformImpl.isModLoaded(id);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Collection<String> getModIds() {
        return PlatformImpl.getModIds();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isClient() {
        return PlatformImpl.isClient();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isServer() {
        return PlatformImpl.isServer();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isForge() {
        return PlatformImpl.isForge();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isFabric() {
        return PlatformImpl.isFabric();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static MinecraftServer getCurrentServer() {
        return PlatformImpl.getCurrentServer();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Path getFolder() {
        return PlatformImpl.getFolder();
    }

    @ExpectPlatform
    @Nullable
    @ExpectPlatform.Transformed
    public static Mod getMod(String modId) {
        return PlatformImpl.getMod(modId);
    }

    public static boolean isArchitecturyLoaded() {
        if (ARCHITECTURY_LOADED == 0) {
            ARCHITECTURY_LOADED = (byte)(Platform.isModLoaded("architectury") ? 2 : 1);
        }
        return ARCHITECTURY_LOADED == 2;
    }

    public record Mod(String modId, String version, String name, String description) {
    }
}

