/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladiumcore.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_3222;
import net.threetag.palladiumcore.event.LifecycleEvents;
import net.threetag.palladiumcore.event.PlayerEvents;
import net.threetag.palladiumcore.network.MessageS2C;

public class DataSyncUtil {
    private static final List<DataSync> DATA_SYNC = new ArrayList<DataSync>();
    private static final List<EntitySync> ENTITY_SYNC = new ArrayList<EntitySync>();

    public static void registerDataSync(DataSync dataSync) {
        DATA_SYNC.add(dataSync);
    }

    public static void registerEntitySync(EntitySync entitySync) {
        ENTITY_SYNC.add(entitySync);
    }

    public static void setupEvents() {
        LifecycleEvents.DATAPACK_SYNC.register((playerList, player) -> {
            for (DataSync dataSync : DATA_SYNC) {
                if (player == null) {
                    dataSync.gatherMessages(msg -> {
                        for (class_3222 pl : playerList.method_14571()) {
                            msg.send(pl);
                        }
                    });
                    continue;
                }
                dataSync.gatherMessages(msg -> msg.send(player));
            }
        });
        PlayerEvents.JOIN.register(player -> {
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                for (EntitySync entitySync : ENTITY_SYNC) {
                    entitySync.gatherMessages((class_1297)serverPlayer, msg -> msg.send(serverPlayer));
                }
            }
        });
        PlayerEvents.START_TRACKING.register((tracker, target) -> {
            if (tracker instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)tracker;
                for (EntitySync entitySync : ENTITY_SYNC) {
                    entitySync.gatherMessages(target, msg -> msg.send(serverPlayer));
                }
            }
        });
        PlayerEvents.RESPAWN.register((player, endConquered) -> {
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                for (EntitySync entitySync : ENTITY_SYNC) {
                    entitySync.gatherMessages((class_1297)player, msg -> msg.sendToTrackingAndSelf(serverPlayer));
                }
            }
        });
        PlayerEvents.CHANGED_DIMENSION.register((player, destination) -> {
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                for (EntitySync entitySync : ENTITY_SYNC) {
                    entitySync.gatherMessages((class_1297)player, msg -> msg.sendToTrackingAndSelf(serverPlayer));
                }
            }
        });
    }

    @FunctionalInterface
    public static interface EntitySync {
        public void gatherMessages(class_1297 var1, Consumer<MessageS2C> var2);
    }

    @FunctionalInterface
    public static interface DataSync {
        public void gatherMessages(Consumer<MessageS2C> var1);
    }
}

