/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladiumcore.network.fabric;

import java.util.UUID;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_7923;
import net.threetag.palladiumcore.PalladiumCore;
import net.threetag.palladiumcore.network.ExtendedEntitySpawnData;

public class SpawnEntityPacket {
    private static final class_2960 PACKET_ID = PalladiumCore.id("spawn_entity_packet");

    public static class_2596<?> create(class_1297 entity) {
        if (entity.method_37908().method_8608()) {
            throw new IllegalStateException("SpawnPacketUtil.create called on the logical client!");
        }
        class_2540 buffer = PacketByteBufs.create();
        buffer.method_10812(class_7923.field_41177.method_10221((Object)entity.method_5864()));
        buffer.method_10797(entity.method_5667());
        buffer.method_10804(entity.method_5628());
        class_243 position = entity.method_19538();
        buffer.writeDouble(position.field_1352);
        buffer.writeDouble(position.field_1351);
        buffer.writeDouble(position.field_1350);
        buffer.writeFloat(entity.method_36455());
        buffer.writeFloat(entity.method_36454());
        buffer.writeFloat(entity.method_5791());
        class_243 deltaMovement = entity.method_18798();
        buffer.writeDouble(deltaMovement.field_1352);
        buffer.writeDouble(deltaMovement.field_1351);
        buffer.writeDouble(deltaMovement.field_1350);
        if (entity instanceof ExtendedEntitySpawnData) {
            ExtendedEntitySpawnData ext = (ExtendedEntitySpawnData)entity;
            ext.saveAdditionalSpawnData(buffer);
        }
        return ServerPlayNetworking.createS2CPacket((class_2960)PACKET_ID, (class_2540)buffer);
    }

    @Environment(value=EnvType.CLIENT)
    public static class Client {
        public static void register() {
            ClientPlayNetworking.registerGlobalReceiver((class_2960)PACKET_ID, (client, handler, buf, responseSender) -> Client.receive(buf, arg_0 -> ((class_310)client).execute(arg_0)));
        }

        public static void receive(class_2540 buf, Consumer<Runnable> consumer) {
            class_2960 entityTypeId = buf.method_10810();
            UUID uuid = buf.method_10790();
            int id = buf.method_10816();
            double x = buf.readDouble();
            double y = buf.readDouble();
            double z = buf.readDouble();
            float xRot = buf.readFloat();
            float yRot = buf.readFloat();
            float yHeadRot = buf.readFloat();
            double deltaX = buf.readDouble();
            double deltaY = buf.readDouble();
            double deltaZ = buf.readDouble();
            buf.retain();
            consumer.accept(() -> {
                if (!class_7923.field_41177.method_10250(entityTypeId)) {
                    throw new IllegalStateException("Entity type (" + entityTypeId + ") is unknown, spawning at (" + x + ", " + y + ", " + z + ")");
                }
                if (class_310.method_1551().field_1687 == null) {
                    throw new IllegalStateException("Client world is null!");
                }
                class_1299 entityType = (class_1299)class_7923.field_41177.method_10223(entityTypeId);
                class_1297 entity = entityType.method_5883((class_1937)class_310.method_1551().field_1687);
                if (entity == null) {
                    throw new IllegalStateException("Created entity is null!");
                }
                entity.method_5826(uuid);
                entity.method_5838(id);
                entity.method_43391(x, y, z);
                entity.method_5641(x, y, z, yRot, xRot);
                entity.method_5847(yHeadRot);
                entity.method_5636(yHeadRot);
                if (entity instanceof ExtendedEntitySpawnData) {
                    ExtendedEntitySpawnData ext = (ExtendedEntitySpawnData)entity;
                    ext.loadAdditionalSpawnData(buf);
                }
                buf.release();
                class_310.method_1551().field_1687.method_2942(id, entity);
                entity.method_5750(deltaX, deltaY, deltaZ);
            });
        }
    }
}

