/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladiumcore.mixin.fabric;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.threetag.palladiumcore.event.LivingEntityEvents;
import net.threetag.palladiumcore.item.IPalladiumItem;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin {
    @Unique
    private float palladiumcore_cachedDamageValue = 0.0f;
    @Unique
    private class_1282 palladiumcore_cachedDamageSource = null;
    @Shadow
    protected class_1799 field_6277;
    @Shadow
    protected int field_6222;

    @Shadow
    public abstract class_1799 method_5998(class_1268 var1);

    @Shadow
    protected abstract void method_30128();

    @Shadow
    public abstract class_1268 method_6058();

    @Shadow
    protected abstract void method_6076();

    @Shadow
    public abstract void method_6021();

    @Shadow
    protected abstract float method_6132(class_1282 var1, float var2);

    @Inject(at={@At(value="HEAD")}, method={"die"}, cancellable=true)
    private void die(class_1282 source, CallbackInfo ci) {
        if (LivingEntityEvents.DEATH.invoker().livingEntityDeath((class_1309)this, source).cancelsEvent()) {
            ci.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"actuallyHurt"}, cancellable=true)
    private void actuallyHurt(class_1282 pDamageSource, float pDamageAmount, CallbackInfo ci) {
        class_1309 entity = (class_1309)this;
        AtomicReference<Float> amount = new AtomicReference<Float>(Float.valueOf(pDamageAmount));
        if (!entity.method_5679(pDamageSource) && (LivingEntityEvents.HURT.invoker().livingEntityHurt(entity, pDamageSource, amount).cancelsEvent() || amount.get().floatValue() <= 0.0f)) {
            ci.cancel();
        }
        this.palladiumcore_cachedDamageSource = pDamageSource;
        this.palladiumcore_cachedDamageValue = amount.get().floatValue();
    }

    @Inject(at={@At(value="HEAD")}, method={"hurt"}, cancellable=true)
    private void hurt(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        class_1309 entity = (class_1309)this;
        if (!(entity instanceof class_1657) && LivingEntityEvents.ATTACK.invoker().livingEntityAttack(entity, source, amount).cancelsEvent()) {
            cir.setReturnValue((Object)false);
        }
    }

    @ModifyVariable(method={"actuallyHurt"}, at=@At(value="STORE", ordinal=0), ordinal=0, argsOnly=true)
    private float modifiedDamageAmount(float damageAmount) {
        return this.method_6132(this.palladiumcore_cachedDamageSource, this.palladiumcore_cachedDamageValue);
    }

    @Inject(at={@At(value="HEAD")}, method={"tick"})
    private void tick(CallbackInfo callbackInfo) {
        class_1309 entity = (class_1309)this;
        LivingEntityEvents.TICK.invoker().livingEntityTick(entity);
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;getUseDuration()I", shift=At.Shift.AFTER)}, method={"startUsingItem"}, cancellable=true)
    private void startUsingItem(class_1268 hand, CallbackInfo ci) {
        class_1309 entity = (class_1309)this;
        class_1799 stack = this.method_5998(hand);
        AtomicInteger duration = new AtomicInteger(stack.method_7935());
        if (LivingEntityEvents.ITEM_USE_START.invoker().livingEntityItemUse(entity, stack, duration).cancelsEvent() || duration.get() <= 0) {
            this.field_6277 = class_1799.field_8037;
            this.field_6222 = 0;
            ci.cancel();
        } else {
            this.field_6222 = duration.get();
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;updateUsingItem(Lnet/minecraft/world/item/ItemStack;)V")}, method={"updatingUsingItem"})
    private void updatingUsingItem(CallbackInfo ci) {
        class_1309 entity = (class_1309)this;
        class_1799 stack = this.method_5998(this.method_6058());
        AtomicInteger duration = new AtomicInteger(this.field_6222);
        if (LivingEntityEvents.ITEM_USE_TICK.invoker().livingEntityItemUse(entity, stack, duration).cancelsEvent()) {
            duration.set(-1);
        }
        this.field_6222 = duration.get();
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;releaseUsing(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;I)V")}, method={"releaseUsingItem"}, cancellable=true)
    private void releaseUsingItem(CallbackInfo ci) {
        class_1309 entity = (class_1309)this;
        AtomicInteger duration = new AtomicInteger(this.field_6222);
        if (LivingEntityEvents.ITEM_USE_STOP.invoker().livingEntityItemUse(entity, this.field_6277, duration).cancelsEvent()) {
            ci.cancel();
            if (this.field_6277.method_7967()) {
                this.method_6076();
            }
            this.method_6021();
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;finishUsingItem(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;)Lnet/minecraft/world/item/ItemStack;", shift=At.Shift.AFTER)}, method={"completeUsingItem"})
    private void completeUsingItem(CallbackInfo ci) {
        class_1309 entity = (class_1309)this;
        AtomicInteger duration = new AtomicInteger(this.field_6222);
        LivingEntityEvents.ITEM_USE_FINISH.invoker().livingEntityItemUseFinish(entity, this.field_6277, duration);
    }

    @Inject(method={"getEquipmentSlotForItem"}, at={@At(value="HEAD")}, cancellable=true)
    private static void getEquipmentSlotForItem(class_1799 item, CallbackInfoReturnable<class_1304> ci) {
        IPalladiumItem palladiumItem;
        class_1304 slot;
        class_1792 class_17922 = item.method_7909();
        if (class_17922 instanceof IPalladiumItem && (slot = (palladiumItem = (IPalladiumItem)class_17922).getEquipmentSlot(item)) != null) {
            ci.setReturnValue((Object)slot);
        }
    }
}

