/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladiumcore.event;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.threetag.palladiumcore.event.EventResult;

public class Event<T> {
    private final Map<T, Priority> handlers = new HashMap<T, Priority>();
    private final Function<List<T>, T> multiplexer;
    private T invoker;

    public Event(Class<T> handlerClass, Function<List<T>, T> multiplexer) {
        this.multiplexer = multiplexer;
        this.update();
    }

    public void register(T handler) {
        this.register(Priority.NORMAL, handler);
    }

    public void register(Priority priority, T handler) {
        this.handlers.put(handler, priority);
        this.update();
    }

    private void update() {
        ArrayList<T> listeners = new ArrayList<T>(this.handlers.keySet());
        listeners.sort(Comparator.comparingInt(value -> this.handlers.get(value).ordinal()));
        this.invoker = this.multiplexer.apply(listeners);
    }

    public T invoker() {
        return this.invoker;
    }

    public static <T> EventResult result(List<T> listeners, Function<T, EventResult> function) {
        boolean cancel = false;
        for (T listener : listeners) {
            EventResult result = function.apply(listener);
            if (result.cancelsEvent()) {
                cancel = true;
            }
            if (!result.stopsListeners()) continue;
            break;
        }
        return cancel ? EventResult.cancel() : EventResult.pass();
    }

    public static enum Priority {
        HIGHEST,
        HIGH,
        NORMAL,
        LOW,
        LOWEST;

    }
}

