/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.compiler;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.luaj.vm2.LoadState;
import org.luaj.vm2.LocVars;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Prototype;

public class DumpState {
    public static boolean ALLOW_INTEGER_CASTING = false;
    public static final int NUMBER_FORMAT_FLOATS_OR_DOUBLES = 0;
    public static final int NUMBER_FORMAT_INTS_ONLY = 1;
    public static final int NUMBER_FORMAT_NUM_PATCH_INT32 = 4;
    public static final int NUMBER_FORMAT_DEFAULT = 0;
    private boolean IS_LITTLE_ENDIAN = true;
    private int NUMBER_FORMAT = 0;
    private int SIZEOF_LUA_NUMBER = 8;
    private static final int SIZEOF_INT = 4;
    private static final int SIZEOF_SIZET = 4;
    private static final int SIZEOF_INSTRUCTION = 4;
    DataOutputStream writer;
    boolean strip;
    int status;

    public DumpState(OutputStream w, boolean strip) {
        this.writer = new DataOutputStream(w);
        this.strip = strip;
        this.status = 0;
    }

    void dumpBlock(byte[] b, int size) throws IOException {
        this.writer.write(b, 0, size);
    }

    void dumpChar(int b) throws IOException {
        this.writer.write(b);
    }

    void dumpInt(int x) throws IOException {
        if (this.IS_LITTLE_ENDIAN) {
            this.writer.writeByte(x & 0xFF);
            this.writer.writeByte(x >> 8 & 0xFF);
            this.writer.writeByte(x >> 16 & 0xFF);
            this.writer.writeByte(x >> 24 & 0xFF);
        } else {
            this.writer.writeInt(x);
        }
    }

    void dumpString(LuaString s) throws IOException {
        int len = s.len().toint();
        this.dumpInt(len + 1);
        s.write(this.writer, 0, len);
        this.writer.write(0);
    }

    void dumpDouble(double d) throws IOException {
        long l = Double.doubleToLongBits(d);
        if (this.IS_LITTLE_ENDIAN) {
            this.dumpInt((int)l);
            this.dumpInt((int)(l >> 32));
        } else {
            this.writer.writeLong(l);
        }
    }

    void dumpCode(Prototype f) throws IOException {
        int[] code = f.code;
        int n = code.length;
        this.dumpInt(n);
        for (int i = 0; i < n; ++i) {
            this.dumpInt(code[i]);
        }
    }

    void dumpConstants(Prototype f) throws IOException {
        int i;
        LuaValue[] k = f.k;
        int n = k.length;
        this.dumpInt(n);
        block11: for (i = 0; i < n; ++i) {
            LuaValue o = k[i];
            switch (o.type()) {
                case 0: {
                    this.writer.write(0);
                    continue block11;
                }
                case 1: {
                    this.writer.write(1);
                    this.dumpChar(o.toboolean() ? 1 : 0);
                    continue block11;
                }
                case 3: {
                    switch (this.NUMBER_FORMAT) {
                        case 0: {
                            this.writer.write(3);
                            this.dumpDouble(o.todouble());
                            continue block11;
                        }
                        case 1: {
                            if (!ALLOW_INTEGER_CASTING && !o.isint()) {
                                throw new IllegalArgumentException("not an integer: " + o);
                            }
                            this.writer.write(3);
                            this.dumpInt(o.toint());
                            continue block11;
                        }
                        case 4: {
                            if (o.isint()) {
                                this.writer.write(-2);
                                this.dumpInt(o.toint());
                                continue block11;
                            }
                            this.writer.write(3);
                            this.dumpDouble(o.todouble());
                            continue block11;
                        }
                    }
                    throw new IllegalArgumentException("number format not supported: " + this.NUMBER_FORMAT);
                }
                case 4: {
                    this.writer.write(4);
                    this.dumpString((LuaString)o);
                    continue block11;
                }
                default: {
                    throw new IllegalArgumentException("bad type for " + o);
                }
            }
        }
        n = f.p.length;
        this.dumpInt(n);
        for (i = 0; i < n; ++i) {
            this.dumpFunction(f.p[i]);
        }
    }

    void dumpUpvalues(Prototype f) throws IOException {
        int n = f.upvalues.length;
        this.dumpInt(n);
        for (int i = 0; i < n; ++i) {
            this.writer.writeByte(f.upvalues[i].instack ? 1 : 0);
            this.writer.writeByte(f.upvalues[i].idx);
        }
    }

    void dumpDebug(Prototype f) throws IOException {
        int i;
        if (this.strip) {
            this.dumpInt(0);
        } else {
            this.dumpString(f.source);
        }
        int n = this.strip ? 0 : f.lineinfo.length;
        this.dumpInt(n);
        for (i = 0; i < n; ++i) {
            this.dumpInt(f.lineinfo[i]);
        }
        n = this.strip ? 0 : f.locvars.length;
        this.dumpInt(n);
        for (i = 0; i < n; ++i) {
            LocVars lvi = f.locvars[i];
            this.dumpString(lvi.varname);
            this.dumpInt(lvi.startpc);
            this.dumpInt(lvi.endpc);
        }
        n = this.strip ? 0 : f.upvalues.length;
        this.dumpInt(n);
        for (i = 0; i < n; ++i) {
            this.dumpString(f.upvalues[i].name);
        }
    }

    void dumpFunction(Prototype f) throws IOException {
        this.dumpInt(f.linedefined);
        this.dumpInt(f.lastlinedefined);
        this.dumpChar(f.numparams);
        this.dumpChar(f.is_vararg);
        this.dumpChar(f.maxstacksize);
        this.dumpCode(f);
        this.dumpConstants(f);
        this.dumpUpvalues(f);
        this.dumpDebug(f);
    }

    void dumpHeader() throws IOException {
        this.writer.write(LoadState.LUA_SIGNATURE);
        this.writer.write(82);
        this.writer.write(0);
        this.writer.write(this.IS_LITTLE_ENDIAN ? 1 : 0);
        this.writer.write(4);
        this.writer.write(4);
        this.writer.write(4);
        this.writer.write(this.SIZEOF_LUA_NUMBER);
        this.writer.write(this.NUMBER_FORMAT);
        this.writer.write(LoadState.LUAC_TAIL);
    }

    public static int dump(Prototype f, OutputStream w, boolean strip) throws IOException {
        DumpState D = new DumpState(w, strip);
        D.dumpHeader();
        D.dumpFunction(f);
        return D.status;
    }

    public static int dump(Prototype f, OutputStream w, boolean stripDebug, int numberFormat, boolean littleendian) throws IOException {
        switch (numberFormat) {
            case 0: 
            case 1: 
            case 4: {
                break;
            }
            default: {
                throw new IllegalArgumentException("number format not supported: " + numberFormat);
            }
        }
        DumpState D = new DumpState(w, stripDebug);
        D.IS_LITTLE_ENDIAN = littleendian;
        D.NUMBER_FORMAT = numberFormat;
        D.SIZEOF_LUA_NUMBER = numberFormat == 1 ? 4 : 8;
        D.dumpHeader();
        D.dumpFunction(f);
        return D.status;
    }
}

