/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.playerdata.api.storage;

import eu.pb4.playerdata.api.PlayerDataApi;
import eu.pb4.playerdata.api.storage.PlayerDataStorage;
import eu.pb4.playerdata.impl.PMI;
import java.io.File;
import java.nio.file.Path;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.server.MinecraftServer;

public record NbtDataStorage(String path) implements PlayerDataStorage<class_2487>
{
    @Override
    public boolean save(MinecraftServer server, UUID player, class_2487 settings) {
        if (settings == null) {
            return false;
        }
        try {
            Path path = PlayerDataApi.getPathFor(server, player);
            path.toFile().mkdirs();
            class_2507.method_30614((class_2487)settings, (File)path.resolve(this.path + ".dat").toFile());
            return true;
        }
        catch (Exception e) {
            PMI.LOGGER.error(String.format("Couldn't save player data of %s for path %s", player, this.path));
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public class_2487 load(MinecraftServer server, UUID player) {
        try {
            Path path = PlayerDataApi.getPathFor(server, player).resolve(this.path + ".dat");
            if (!path.toFile().exists()) {
                return null;
            }
            return class_2507.method_30613((File)path.toFile());
        }
        catch (Exception e) {
            PMI.LOGGER.error(String.format("Couldn't load player data of %s for path %s", player, this.path));
            e.printStackTrace();
            return null;
        }
    }
}

