/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.playerdata.api;

import com.google.common.collect.ImmutableSet;
import eu.pb4.playerdata.api.storage.NbtDataStorage;
import eu.pb4.playerdata.api.storage.PlayerDataStorage;
import eu.pb4.playerdata.impl.PMI;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4614;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public final class PlayerDataApi {
    private static final PlayerDataStorage<class_2487> GLOBAL_DATA_STORAGE = new NbtDataStorage("general");
    private static final Set<PlayerDataStorage<?>> STORAGE = new HashSet();

    private PlayerDataApi() {
    }

    public static <T extends PlayerDataStorage<?>> boolean register(T dataStorage) {
        return STORAGE.add(dataStorage);
    }

    @Nullable
    public static class_2520 getGlobalDataFor(class_3222 player, class_2960 identifier) {
        class_2487 data = PlayerDataApi.getCustomDataFor(player, GLOBAL_DATA_STORAGE);
        return data != null ? data.method_10580(identifier.toString()) : null;
    }

    @Nullable
    public static <T extends class_2520> T getGlobalDataFor(class_3222 player, class_2960 identifier, class_4614<T> type) {
        class_2520 data = PlayerDataApi.getGlobalDataFor(player, identifier);
        return (T)(data != null && data.method_23258() == type ? data : null);
    }

    public static void setGlobalDataFor(class_3222 player, class_2960 identifier, class_2520 element) {
        class_2487 data = PlayerDataApi.getCustomDataFor(player, GLOBAL_DATA_STORAGE);
        if (data == null) {
            data = new class_2487();
            PlayerDataApi.setCustomDataFor(player, GLOBAL_DATA_STORAGE, data);
        }
        if (element != null) {
            data.method_10566(identifier.toString(), element);
        } else {
            data.method_10551(identifier.toString());
        }
    }

    @Nullable
    public static <T> T getCustomDataFor(class_3222 player, PlayerDataStorage<T> storage) {
        return PlayerDataApi.getCustomDataFor(player.field_13995, player.method_5667(), storage);
    }

    public static <T> void setCustomDataFor(class_3222 player, PlayerDataStorage<T> storage, T value) {
        PlayerDataApi.setCustomDataFor(player.field_13995, player.method_5667(), storage, value);
    }

    @Nullable
    public static <T> T getCustomDataFor(MinecraftServer server, UUID uuid, PlayerDataStorage<T> storage) {
        PMI pmi = (PMI)server.method_3760();
        if (pmi.pda_isStored(uuid)) {
            return pmi.pda_getStorageValue(uuid, storage);
        }
        return storage.load(server, uuid);
    }

    public static <T> void setCustomDataFor(MinecraftServer server, UUID uuid, PlayerDataStorage<T> storage, T value) {
        PMI pmi = (PMI)server.method_3760();
        if (pmi.pda_isStored(uuid)) {
            pmi.pda_setStorageValue(uuid, storage, value);
        } else {
            storage.save(server, uuid, value);
        }
    }

    public static ImmutableSet<PlayerDataStorage<?>> getDataStorageSet() {
        return ImmutableSet.copyOf(STORAGE);
    }

    public static Path getPathFor(class_3222 player) {
        return PlayerDataApi.getPathFor(player.field_13995, player.method_5667());
    }

    public static Path getPathFor(MinecraftServer server, UUID uuid) {
        return server.method_27050(class_5218.field_24188).resolve("player-mod-data").resolve(uuid.toString());
    }

    static {
        PlayerDataApi.register(GLOBAL_DATA_STORAGE);
    }
}

