/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.predicate.impl.predicates.generic;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import eu.pb4.predicate.api.AbstractPredicate;
import eu.pb4.predicate.api.MinecraftPredicate;
import eu.pb4.predicate.api.PredicateContext;
import eu.pb4.predicate.api.PredicateResult;
import eu.pb4.predicate.impl.predicates.GenericObject;
import java.util.function.BiFunction;
import net.minecraft.class_2960;

public abstract class NumberPredicate
extends AbstractPredicate {
    private final Object valueA;
    private final Object valueB;
    private final MinecraftPredicate predicate1;
    private final MinecraftPredicate predicate2;

    public static final <T extends NumberPredicate> MapCodec<T> codec(BiFunction<Object, Object, T> creator) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)GenericObject.CODEC.fieldOf("value_1").forGetter(NumberPredicate::valueA), (App)GenericObject.CODEC.fieldOf("value_2").forGetter(NumberPredicate::valueB)).apply((Applicative)instance, creator));
    }

    public <T extends MinecraftPredicate> NumberPredicate(class_2960 identifier, MapCodec<T> codec, Object valueA, Object valueB) {
        super(identifier, codec);
        this.valueA = valueA;
        this.valueB = valueB;
        this.predicate1 = GenericObject.toPredicate(valueA);
        this.predicate2 = GenericObject.toPredicate(valueB);
    }

    public Object valueA() {
        return this.valueA;
    }

    public Object valueB() {
        return this.valueB;
    }

    @Override
    public PredicateResult<?> test(PredicateContext context) {
        PredicateResult<?> val1 = this.predicate1.test(context);
        PredicateResult<?> val2 = this.predicate2.test(context);
        return this.check(GenericObject.toNumber(val1.value(), val1.success()), GenericObject.toNumber(val2.value(), val2.success())) ? new PredicateResult(true, val1.value()) : new PredicateResult(false, val2.value());
    }

    protected abstract boolean check(double var1, double var3);

    public static final class MoreEqual
    extends NumberPredicate {
        public static final class_2960 ID = new class_2960("more_or_equal");
        public static final MapCodec<MoreEqual> CODEC = NumberPredicate.codec(MoreEqual::new);

        public MoreEqual(Object valueA, Object valueB) {
            super(ID, CODEC, valueA, valueB);
        }

        @Override
        protected boolean check(double a, double b) {
            return a >= b;
        }
    }

    public static final class MoreThan
    extends NumberPredicate {
        public static final class_2960 ID = new class_2960("more_than");
        public static final MapCodec<MoreThan> CODEC = NumberPredicate.codec(MoreThan::new);

        public MoreThan(Object valueA, Object valueB) {
            super(ID, CODEC, valueA, valueB);
        }

        @Override
        protected boolean check(double a, double b) {
            return a > b;
        }
    }

    public static final class LessEqual
    extends NumberPredicate {
        public static final class_2960 ID = new class_2960("less_or_equal");
        public static final MapCodec<LessEqual> CODEC = NumberPredicate.codec(LessEqual::new);

        public LessEqual(Object valueA, Object valueB) {
            super(ID, CODEC, valueA, valueB);
        }

        @Override
        protected boolean check(double a, double b) {
            return a <= b;
        }
    }

    public static final class LessThan
    extends NumberPredicate {
        public static final class_2960 ID = new class_2960("less_than");
        public static final MapCodec<LessThan> CODEC = NumberPredicate.codec(LessThan::new);

        public LessThan(Object valueA, Object valueB) {
            super(ID, CODEC, valueA, valueB);
        }

        @Override
        protected boolean check(double a, double b) {
            return a < b;
        }
    }
}

