/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.lib.net.impl;

import alexiil.mc.lib.net.BufferedConnection;
import alexiil.mc.lib.net.EnumNetSide;
import alexiil.mc.lib.net.LibNetworkStack;
import alexiil.mc.lib.net.NetByteBuf;
import alexiil.mc.lib.net.NetIdData;
import alexiil.mc.lib.net.impl.ActiveClientConnection;
import alexiil.mc.lib.net.impl.ActiveServerConnection;
import alexiil.mc.lib.net.impl.CoreMinecraftNetUtil;
import alexiil.mc.lib.net.impl.McNetworkStack;
import net.minecraft.class_1657;
import net.minecraft.class_2596;
import net.minecraft.class_2960;

public abstract class ActiveMinecraftConnection
extends BufferedConnection {
    public static final class_2960 PACKET_ID = new class_2960("libnetworkstack", "data");
    private static final NetIdData NET_ID_COMPACT_PACKET = McNetworkStack.ROOT.idData("libnetworkstack:compact_id", 4).setReceiver((buffer, ctx) -> {
        int theirCustomId = buffer.readInt();
        ActiveMinecraftConnection connection = (ActiveMinecraftConnection)ctx.getConnection();
        connection.theirCustomId = theirCustomId;
        if (LibNetworkStack.DEBUG) {
            LibNetworkStack.LOGGER.info(connection + " Received their custom id " + theirCustomId);
        }
    });
    static final NetIdData NET_ID_SERVER_TICK = McNetworkStack.ROOT.idData("libnetworkstack:server_tick", 16).setReceiver((buffer, ctx) -> {
        ctx.assertClientSide();
        long tick = buffer.readLong();
        long sendTime = buffer.readLong();
        ((ActiveClientConnection)ctx.getConnection()).receiveServerTick(tick, sendTime);
    });
    private static final int NET_ID_NOT_OPTIMISED = 0;
    private static final boolean COMPACT_PACKETS = true;
    private int theirCustomId = 0;
    private boolean hasSentCustomId;

    public ActiveMinecraftConnection() {
        super(McNetworkStack.ROOT, 60);
    }

    @Override
    public abstract EnumNetSide getNetSide();

    @Override
    public abstract class_1657 getPlayer();

    @Override
    public final void sendRawData0(NetByteBuf data) {
        class_2596<?> packet;
        if (this.theirCustomId != 0) {
            packet = this.toCompactPacket(this.theirCustomId, data);
        } else {
            data.retain();
            packet = this.toNormalPacket(data);
        }
        this.sendPacket(packet);
    }

    @Override
    public void tick() {
        if (!this.hasSentCustomId && this.hasPackets()) {
            this.hasSentCustomId = true;
            this.sendCustomId();
        }
        super.tick();
    }

    private void sendCustomId() {
        int ourCustomId = this instanceof ActiveServerConnection ? CoreMinecraftNetUtil.serverExpectedId : CoreMinecraftNetUtil.clientExpectedId;
        NET_ID_COMPACT_PACKET.send(this, (buffer, c) -> buffer.writeInt(ourCustomId));
        if (LibNetworkStack.DEBUG) {
            LibNetworkStack.LOGGER.info(this + " Sent our custom id " + ourCustomId);
        }
    }

    protected abstract class_2596<?> toNormalPacket(NetByteBuf var1);

    protected abstract class_2596<?> toCompactPacket(int var1, NetByteBuf var2);

    protected abstract void sendPacket(class_2596<?> var1);
}

